/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.selectable.DebitMemoReqItemTextSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
 * DebitMemoReqItemText} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class DebitMemoReqItemTextLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<DebitMemoReqItemTextLink<ObjectT>, DebitMemoReqItemText, ObjectT>
    implements
    DebitMemoReqItemTextSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public DebitMemoReqItemTextLink( final String fieldName )
    {
        super(fieldName);
    }

    private DebitMemoReqItemTextLink(
        final EntityLink<DebitMemoReqItemTextLink<ObjectT>, DebitMemoReqItemText, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected DebitMemoReqItemTextLink<ObjectT> translateLinkType(
        final EntityLink<DebitMemoReqItemTextLink<ObjectT>, DebitMemoReqItemText, ObjectT> link )
    {
        return new DebitMemoReqItemTextLink<ObjectT>(link);
    }

}
