/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow
 * DbtMemoReqItmSubsqntProcFlow}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.field.DbtMemoReqItmSubsqntProcFlowField
 * DbtMemoReqItmSubsqntProcFlowField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.link.DbtMemoReqItmSubsqntProcFlowLink
 * DbtMemoReqItmSubsqntProcFlowLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#DEBIT_MEMO_REQUEST
 * DEBIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#DEBIT_MEMO_REQUEST_ITEM
 * DEBIT_MEMO_REQUEST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#DOC_RELATIONSHIP_UUID
 * DOC_RELATIONSHIP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#SUBSEQUENT_DOCUMENT
 * SUBSEQUENT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#SUBSEQUENT_DOCUMENT_ITEM
 * SUBSEQUENT_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#SUBSEQUENT_DOCUMENT_CATEGORY
 * SUBSEQUENT_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#PROCESS_FLOW_LEVEL
 * PROCESS_FLOW_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#ACCOUNTING_TRANSFER_STATUS
 * ACCOUNTING_TRANSFER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#SD_PROCESS_STATUS
 * SD_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#RELATED_PROC_FLOW_DOC_STS_FIELD_NAME
 * RELATED_PROC_FLOW_DOC_STS_FIELD_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#SUBSQNT_DOC_ITM_PRECDG_DOCUMENT
 * SUBSQNT_DOC_ITM_PRECDG_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#SUBSQNT_DOC_ITM_PRECDG_DOC_ITEM
 * SUBSQNT_DOC_ITM_PRECDG_DOC_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#SUBSQNT_DOC_ITM_PRECDG_DOC_CATEGORY
 * SUBSQNT_DOC_ITM_PRECDG_DOC_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#TO_DEBIT_MEMO_REQUEST
 * TO_DEBIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow#TO_DEBIT_MEMO_REQUEST_ITEM
 * TO_DEBIT_MEMO_REQUEST_ITEM}</li>
 * </ul>
 *
 */
public interface DbtMemoReqItmSubsqntProcFlowSelectable extends EntitySelectable<DbtMemoReqItmSubsqntProcFlow>
{

}
