/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
 * DebitMemoReqItemPartner}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.field.DebitMemoReqItemPartnerField
 * DebitMemoReqItemPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.link.DebitMemoReqItemPartnerLink
 * DebitMemoReqItemPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner#DEBIT_MEMO_REQUEST
 * DEBIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner#DEBIT_MEMO_REQUEST_ITEM
 * DEBIT_MEMO_REQUEST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner#TO_DEBIT_MEMO_REQUEST
 * TO_DEBIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner#TO_DEBIT_MEMO_REQUEST_ITEM
 * TO_DEBIT_MEMO_REQUEST_ITEM}</li>
 * </ul>
 *
 */
public interface DebitMemoReqItemPartnerSelectable extends EntitySelectable<DebitMemoReqItemPartner>
{

}
