/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
 * DebitMemoReqItemText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.field.DebitMemoReqItemTextField
 * DebitMemoReqItemTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.link.DebitMemoReqItemTextLink
 * DebitMemoReqItemTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText#DEBIT_MEMO_REQUEST
 * DEBIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText#DEBIT_MEMO_REQUEST_ITEM
 * DEBIT_MEMO_REQUEST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText#LONG_TEXT_ID
 * LONG_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText#LONG_TEXT
 * LONG_TEXT}</li>
 * </ul>
 *
 */
public interface DebitMemoReqItemTextSelectable extends EntitySelectable<DebitMemoReqItemText>
{

}
