/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
 * DebitMemoRequestItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.field.DebitMemoRequestItemField
 * DebitMemoRequestItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.link.DebitMemoRequestItemLink
 * DebitMemoRequestItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#DEBIT_MEMO_REQUEST
 * DEBIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#DEBIT_MEMO_REQUEST_ITEM
 * DEBIT_MEMO_REQUEST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#HIGHER_LEVEL_ITEM
 * HIGHER_LEVEL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#DEBIT_MEMO_REQUEST_ITEM_CATEGORY
 * DEBIT_MEMO_REQUEST_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#DEBIT_MEMO_REQUEST_ITEM_TEXT
 * DEBIT_MEMO_REQUEST_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#PURCHASE_ORDER_BY_CUSTOMER
 * PURCHASE_ORDER_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#MATERIAL_BY_CUSTOMER
 * MATERIAL_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#PRICING_DATE
 * PRICING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#REQUESTED_QUANTITY
 * REQUESTED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#REQUESTED_QUANTITY_UNIT
 * REQUESTED_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#REQUESTED_QUANTITY_SAP_UNIT
 * REQUESTED_QUANTITY_SAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#REQUESTED_QUANTITY_ISO_UNIT
 * REQUESTED_QUANTITY_ISO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#ITEM_GROSS_WEIGHT
 * ITEM_GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#ITEM_NET_WEIGHT
 * ITEM_NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#ITEM_WEIGHT_UNIT
 * ITEM_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#ITEM_WEIGHT_SAP_UNIT
 * ITEM_WEIGHT_SAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#ITEM_WEIGHT_ISO_UNIT
 * ITEM_WEIGHT_ISO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#ITEM_VOLUME
 * ITEM_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#ITEM_VOLUME_UNIT
 * ITEM_VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#ITEM_VOLUME_SAP_UNIT
 * ITEM_VOLUME_SAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#ITEM_VOLUME_ISO_UNIT
 * ITEM_VOLUME_ISO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#NET_AMOUNT
 * NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#MATERIAL_PRICING_GROUP
 * MATERIAL_PRICING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#PRODUCT_TAX_CLASSIFICATION1
 * PRODUCT_TAX_CLASSIFICATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#PRODUCT_TAX_CLASSIFICATION2
 * PRODUCT_TAX_CLASSIFICATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#PRODUCT_TAX_CLASSIFICATION3
 * PRODUCT_TAX_CLASSIFICATION3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#PRODUCT_TAX_CLASSIFICATION4
 * PRODUCT_TAX_CLASSIFICATION4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#PRODUCT_TAX_CLASSIFICATION5
 * PRODUCT_TAX_CLASSIFICATION5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#PRODUCT_TAX_CLASSIFICATION6
 * PRODUCT_TAX_CLASSIFICATION6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#PRODUCT_TAX_CLASSIFICATION7
 * PRODUCT_TAX_CLASSIFICATION7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#PRODUCT_TAX_CLASSIFICATION8
 * PRODUCT_TAX_CLASSIFICATION8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#PRODUCT_TAX_CLASSIFICATION9
 * PRODUCT_TAX_CLASSIFICATION9}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#BATCH
 * BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#INCOTERMS_TRANSFER_LOCATION
 * INCOTERMS_TRANSFER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#INCOTERMS_LOCATION1
 * INCOTERMS_LOCATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#INCOTERMS_LOCATION2
 * INCOTERMS_LOCATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#CUSTOMER_PAYMENT_TERMS
 * CUSTOMER_PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#ITEM_BILLING_BLOCK_REASON
 * ITEM_BILLING_BLOCK_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#SALES_DOCUMENT_RJCN_REASON
 * SALES_DOCUMENT_RJCN_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#REFERENCE_SD_DOCUMENT
 * REFERENCE_SD_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#REFERENCE_SD_DOCUMENT_ITEM
 * REFERENCE_SD_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#SD_PROCESS_STATUS
 * SD_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#ORDER_RELATED_BILLING_STATUS
 * ORDER_RELATED_BILLING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#TO_DEBIT_MEMO_REQUEST
 * TO_DEBIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#TO_ITEM_SUBSQNT_PROC_FLOW
 * TO_ITEM_SUBSQNT_PROC_FLOW}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#TO_PARTNER
 * TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#TO_PRICING_ELEMENT
 * TO_PRICING_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface DebitMemoRequestItemSelectable extends EntitySelectable<DebitMemoRequestItem>
{

}
