/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.field.DebitMemoReqCreditSimulationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.selectable.DebitMemoReqCreditSimulationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Debit Memo Request Credit Simulation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DebitMemoReqCreditSimulationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DebitMemoReqCreditSimulation extends VdmEntity<DebitMemoReqCreditSimulation>
{

    /**
     * Selector for all available fields of DebitMemoReqCreditSimulation.
     *
     */
    public final static DebitMemoReqCreditSimulationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequest</b>
     * </p>
     *
     * @return Debit Memo Request
     */
    @Key
    @SerializedName( "DebitMemoRequest" )
    @JsonProperty( "DebitMemoRequest" )
    @Nullable
    @ODataField( odataName = "DebitMemoRequest" )
    private String debitMemoRequest;
    /**
     * Use with available fluent helpers to apply the <b>DebitMemoRequest</b> field to query operations.
     *
     */
    public final static DebitMemoReqCreditSimulationField<String> DEBIT_MEMO_REQUEST =
        new DebitMemoReqCreditSimulationField<String>("DebitMemoRequest");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalCreditCheckStatus</b>
     * </p>
     *
     * @return Overall Status of Credit Checks
     */
    @SerializedName( "TotalCreditCheckStatus" )
    @JsonProperty( "TotalCreditCheckStatus" )
    @Nullable
    @ODataField( odataName = "TotalCreditCheckStatus" )
    private String totalCreditCheckStatus;
    /**
     * Use with available fluent helpers to apply the <b>TotalCreditCheckStatus</b> field to query operations.
     *
     */
    public final static DebitMemoReqCreditSimulationField<String> TOTAL_CREDIT_CHECK_STATUS =
        new DebitMemoReqCreditSimulationField<String>("TotalCreditCheckStatus");

    @Nonnull
    @Override
    public Class<DebitMemoReqCreditSimulation> getType()
    {
        return DebitMemoReqCreditSimulation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequest</b>
     * </p>
     *
     * @param debitMemoRequest
     *            Debit Memo Request
     */
    public void setDebitMemoRequest( @Nullable final String debitMemoRequest )
    {
        rememberChangedField("DebitMemoRequest", this.debitMemoRequest);
        this.debitMemoRequest = debitMemoRequest;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalCreditCheckStatus</b>
     * </p>
     *
     * @param totalCreditCheckStatus
     *            Overall Status of Credit Checks
     */
    public void setTotalCreditCheckStatus( @Nullable final String totalCreditCheckStatus )
    {
        rememberChangedField("TotalCreditCheckStatus", this.totalCreditCheckStatus);
        this.totalCreditCheckStatus = totalCreditCheckStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DebitMemoReqCreditSimulation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DebitMemoRequest", getDebitMemoRequest());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DebitMemoRequest", getDebitMemoRequest());
        values.put("TotalCreditCheckStatus", getTotalCreditCheckStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DebitMemoRequest") ) {
                final Object value = values.remove("DebitMemoRequest");
                if( (value == null) || (!value.equals(getDebitMemoRequest())) ) {
                    setDebitMemoRequest(((String) value));
                }
            }
            if( values.containsKey("TotalCreditCheckStatus") ) {
                final Object value = values.remove("TotalCreditCheckStatus");
                if( (value == null) || (!value.equals(getTotalCreditCheckStatus())) ) {
                    setTotalCreditCheckStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> DebitMemoReqCreditSimulationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new DebitMemoReqCreditSimulationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DebitMemoReqCreditSimulationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DebitMemoReqCreditSimulationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestSimulateService.DEFAULT_SERVICE_PATH);
    }

}
