/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.field.DebitMemoReqItemSimulationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.link.DebitMemoReqItemSimulationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.link.DebitMemoReqItemSimulationOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.selectable.DebitMemoReqItemSimulationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Debit Memo Request Item Simulation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DebitMemoReqItemSimulationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DebitMemoReqItemSimulation extends VdmEntity<DebitMemoReqItemSimulation>
{

    /**
     * Selector for all available fields of DebitMemoReqItemSimulation.
     *
     */
    public final static DebitMemoReqItemSimulationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequest</b>
     * </p>
     *
     * @return Debit Memo Request
     */
    @Key
    @SerializedName( "DebitMemoRequest" )
    @JsonProperty( "DebitMemoRequest" )
    @Nullable
    @ODataField( odataName = "DebitMemoRequest" )
    private String debitMemoRequest;
    /**
     * Use with available fluent helpers to apply the <b>DebitMemoRequest</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> DEBIT_MEMO_REQUEST =
        new DebitMemoReqItemSimulationField<String>("DebitMemoRequest");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequestItem</b>
     * </p>
     *
     * @return Debit Memo Request Item
     */
    @Key
    @SerializedName( "DebitMemoRequestItem" )
    @JsonProperty( "DebitMemoRequestItem" )
    @Nullable
    @ODataField( odataName = "DebitMemoRequestItem" )
    private String debitMemoRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>DebitMemoRequestItem</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> DEBIT_MEMO_REQUEST_ITEM =
        new DebitMemoReqItemSimulationField<String>("DebitMemoRequestItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @return Higher-Level Item in Bill of Material Structures
     */
    @SerializedName( "HigherLevelItem" )
    @JsonProperty( "HigherLevelItem" )
    @Nullable
    @ODataField( odataName = "HigherLevelItem" )
    private String higherLevelItem;
    /**
     * Use with available fluent helpers to apply the <b>HigherLevelItem</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> HIGHER_LEVEL_ITEM =
        new DebitMemoReqItemSimulationField<String>("HigherLevelItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequestItemCategory</b>
     * </p>
     *
     * @return Sales Document Item Category
     */
    @SerializedName( "DebitMemoRequestItemCategory" )
    @JsonProperty( "DebitMemoRequestItemCategory" )
    @Nullable
    @ODataField( odataName = "DebitMemoRequestItemCategory" )
    private String debitMemoRequestItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>DebitMemoRequestItemCategory</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> DEBIT_MEMO_REQUEST_ITEM_CATEGORY =
        new DebitMemoReqItemSimulationField<String>("DebitMemoRequestItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequestItemText</b>
     * </p>
     *
     * @return Short Text for Sales Order Item
     */
    @SerializedName( "DebitMemoRequestItemText" )
    @JsonProperty( "DebitMemoRequestItemText" )
    @Nullable
    @ODataField( odataName = "DebitMemoRequestItemText" )
    private String debitMemoRequestItemText;
    /**
     * Use with available fluent helpers to apply the <b>DebitMemoRequestItemText</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> DEBIT_MEMO_REQUEST_ITEM_TEXT =
        new DebitMemoReqItemSimulationField<String>("DebitMemoRequestItemText");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new DebitMemoReqItemSimulationField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> MATERIAL =
        new DebitMemoReqItemSimulationField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Material Number Used by Customer
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> MATERIAL_BY_CUSTOMER =
        new DebitMemoReqItemSimulationField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @return Date for Pricing and Exchange Rate
     */
    @SerializedName( "PricingDate" )
    @JsonProperty( "PricingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PricingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime pricingDate;
    /**
     * Use with available fluent helpers to apply the <b>PricingDate</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<LocalDateTime> PRICING_DATE =
        new DebitMemoReqItemSimulationField<LocalDateTime>("PricingDate");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @return Requested Quantity
     */
    @SerializedName( "RequestedQuantity" )
    @JsonProperty( "RequestedQuantity" )
    @Nullable
    @ODataField( odataName = "RequestedQuantity" )
    private BigDecimal requestedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantity</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<BigDecimal> REQUESTED_QUANTITY =
        new DebitMemoReqItemSimulationField<BigDecimal>("RequestedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @return Unit of the Requested Quantity
     */
    @SerializedName( "RequestedQuantityUnit" )
    @JsonProperty( "RequestedQuantityUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityUnit" )
    private String requestedQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantityUnit</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> REQUESTED_QUANTITY_UNIT =
        new DebitMemoReqItemSimulationField<String>("RequestedQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantitySAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Requested Quantity
     */
    @SerializedName( "RequestedQuantitySAPUnit" )
    @JsonProperty( "RequestedQuantitySAPUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantitySAPUnit" )
    private String requestedQuantitySAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantitySAPUnit</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> REQUESTED_QUANTITY_SAP_UNIT =
        new DebitMemoReqItemSimulationField<String>("RequestedQuantitySAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Requested Quantity
     */
    @SerializedName( "RequestedQuantityISOUnit" )
    @JsonProperty( "RequestedQuantityISOUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityISOUnit" )
    private String requestedQuantityISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantityISOUnit</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> REQUESTED_QUANTITY_ISO_UNIT =
        new DebitMemoReqItemSimulationField<String>("RequestedQuantityISOUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @return Gross Weight of the Item
     */
    @SerializedName( "ItemGrossWeight" )
    @JsonProperty( "ItemGrossWeight" )
    @Nullable
    @ODataField( odataName = "ItemGrossWeight" )
    private BigDecimal itemGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemGrossWeight</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<BigDecimal> ITEM_GROSS_WEIGHT =
        new DebitMemoReqItemSimulationField<BigDecimal>("ItemGrossWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @return Net Weight of the Item
     */
    @SerializedName( "ItemNetWeight" )
    @JsonProperty( "ItemNetWeight" )
    @Nullable
    @ODataField( odataName = "ItemNetWeight" )
    private BigDecimal itemNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemNetWeight</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<BigDecimal> ITEM_NET_WEIGHT =
        new DebitMemoReqItemSimulationField<BigDecimal>("ItemNetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "ItemWeightUnit" )
    @JsonProperty( "ItemWeightUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightUnit" )
    private String itemWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightUnit</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> ITEM_WEIGHT_UNIT =
        new DebitMemoReqItemSimulationField<String>("ItemWeightUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightSAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Item Weight
     */
    @SerializedName( "ItemWeightSAPUnit" )
    @JsonProperty( "ItemWeightSAPUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightSAPUnit" )
    private String itemWeightSAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightSAPUnit</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> ITEM_WEIGHT_SAP_UNIT =
        new DebitMemoReqItemSimulationField<String>("ItemWeightSAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Item Weight
     */
    @SerializedName( "ItemWeightISOUnit" )
    @JsonProperty( "ItemWeightISOUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightISOUnit" )
    private String itemWeightISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightISOUnit</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> ITEM_WEIGHT_ISO_UNIT =
        new DebitMemoReqItemSimulationField<String>("ItemWeightISOUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @return Volume of the item
     */
    @SerializedName( "ItemVolume" )
    @JsonProperty( "ItemVolume" )
    @Nullable
    @ODataField( odataName = "ItemVolume" )
    private BigDecimal itemVolume;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolume</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<BigDecimal> ITEM_VOLUME =
        new DebitMemoReqItemSimulationField<BigDecimal>("ItemVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "ItemVolumeUnit" )
    @JsonProperty( "ItemVolumeUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeUnit" )
    private String itemVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeUnit</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> ITEM_VOLUME_UNIT =
        new DebitMemoReqItemSimulationField<String>("ItemVolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeSAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Item Volume
     */
    @SerializedName( "ItemVolumeSAPUnit" )
    @JsonProperty( "ItemVolumeSAPUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeSAPUnit" )
    private String itemVolumeSAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeSAPUnit</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> ITEM_VOLUME_SAP_UNIT =
        new DebitMemoReqItemSimulationField<String>("ItemVolumeSAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Item Volume
     */
    @SerializedName( "ItemVolumeISOUnit" )
    @JsonProperty( "ItemVolumeISOUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeISOUnit" )
    private String itemVolumeISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeISOUnit</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> ITEM_VOLUME_ISO_UNIT =
        new DebitMemoReqItemSimulationField<String>("ItemVolumeISOUnit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> TRANSACTION_CURRENCY =
        new DebitMemoReqItemSimulationField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Net Value of the Order Item in Document Currency
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<BigDecimal> NET_AMOUNT =
        new DebitMemoReqItemSimulationField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> MATERIAL_GROUP =
        new DebitMemoReqItemSimulationField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup1</b>
     * </p>
     *
     * @return Material Group 1
     */
    @SerializedName( "AdditionalMaterialGroup1" )
    @JsonProperty( "AdditionalMaterialGroup1" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup1" )
    private String additionalMaterialGroup1;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup1</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> ADDITIONAL_MATERIAL_GROUP1 =
        new DebitMemoReqItemSimulationField<String>("AdditionalMaterialGroup1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup2</b>
     * </p>
     *
     * @return Material Group 2
     */
    @SerializedName( "AdditionalMaterialGroup2" )
    @JsonProperty( "AdditionalMaterialGroup2" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup2" )
    private String additionalMaterialGroup2;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup2</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> ADDITIONAL_MATERIAL_GROUP2 =
        new DebitMemoReqItemSimulationField<String>("AdditionalMaterialGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup3</b>
     * </p>
     *
     * @return Material Group 3
     */
    @SerializedName( "AdditionalMaterialGroup3" )
    @JsonProperty( "AdditionalMaterialGroup3" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup3" )
    private String additionalMaterialGroup3;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup3</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> ADDITIONAL_MATERIAL_GROUP3 =
        new DebitMemoReqItemSimulationField<String>("AdditionalMaterialGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup4</b>
     * </p>
     *
     * @return Material Group 4
     */
    @SerializedName( "AdditionalMaterialGroup4" )
    @JsonProperty( "AdditionalMaterialGroup4" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup4" )
    private String additionalMaterialGroup4;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup4</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> ADDITIONAL_MATERIAL_GROUP4 =
        new DebitMemoReqItemSimulationField<String>("AdditionalMaterialGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup5</b>
     * </p>
     *
     * @return Material Group 5
     */
    @SerializedName( "AdditionalMaterialGroup5" )
    @JsonProperty( "AdditionalMaterialGroup5" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup5" )
    private String additionalMaterialGroup5;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup5</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> ADDITIONAL_MATERIAL_GROUP5 =
        new DebitMemoReqItemSimulationField<String>("AdditionalMaterialGroup5");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @return Material Price Group
     */
    @SerializedName( "MaterialPricingGroup" )
    @JsonProperty( "MaterialPricingGroup" )
    @Nullable
    @ODataField( odataName = "MaterialPricingGroup" )
    private String materialPricingGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPricingGroup</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> MATERIAL_PRICING_GROUP =
        new DebitMemoReqItemSimulationField<String>("MaterialPricingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification1" )
    @JsonProperty( "ProductTaxClassification1" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification1" )
    private String productTaxClassification1;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification1</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION1 =
        new DebitMemoReqItemSimulationField<String>("ProductTaxClassification1");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification2</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification2" )
    @JsonProperty( "ProductTaxClassification2" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification2" )
    private String productTaxClassification2;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification2</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION2 =
        new DebitMemoReqItemSimulationField<String>("ProductTaxClassification2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification3</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification3" )
    @JsonProperty( "ProductTaxClassification3" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification3" )
    private String productTaxClassification3;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification3</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION3 =
        new DebitMemoReqItemSimulationField<String>("ProductTaxClassification3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification4</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification4" )
    @JsonProperty( "ProductTaxClassification4" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification4" )
    private String productTaxClassification4;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification4</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION4 =
        new DebitMemoReqItemSimulationField<String>("ProductTaxClassification4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification5</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification5" )
    @JsonProperty( "ProductTaxClassification5" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification5" )
    private String productTaxClassification5;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification5</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION5 =
        new DebitMemoReqItemSimulationField<String>("ProductTaxClassification5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification6</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification6" )
    @JsonProperty( "ProductTaxClassification6" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification6" )
    private String productTaxClassification6;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification6</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION6 =
        new DebitMemoReqItemSimulationField<String>("ProductTaxClassification6");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification7</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification7" )
    @JsonProperty( "ProductTaxClassification7" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification7" )
    private String productTaxClassification7;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification7</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION7 =
        new DebitMemoReqItemSimulationField<String>("ProductTaxClassification7");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification8</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification8" )
    @JsonProperty( "ProductTaxClassification8" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification8" )
    private String productTaxClassification8;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification8</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION8 =
        new DebitMemoReqItemSimulationField<String>("ProductTaxClassification8");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification9</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification9" )
    @JsonProperty( "ProductTaxClassification9" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification9" )
    private String productTaxClassification9;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification9</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION9 =
        new DebitMemoReqItemSimulationField<String>("ProductTaxClassification9");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> BATCH =
        new DebitMemoReqItemSimulationField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant (Own or External)
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> PLANT =
        new DebitMemoReqItemSimulationField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> INCOTERMS_CLASSIFICATION =
        new DebitMemoReqItemSimulationField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> INCOTERMS_TRANSFER_LOCATION =
        new DebitMemoReqItemSimulationField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> INCOTERMS_LOCATION1 =
        new DebitMemoReqItemSimulationField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> INCOTERMS_LOCATION2 =
        new DebitMemoReqItemSimulationField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "CustomerPaymentTerms" )
    @JsonProperty( "CustomerPaymentTerms" )
    @Nullable
    @ODataField( odataName = "CustomerPaymentTerms" )
    private String customerPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPaymentTerms</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> CUSTOMER_PAYMENT_TERMS =
        new DebitMemoReqItemSimulationField<String>("CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingBlockReason</b>
     * </p>
     *
     * @return Billing Block for Item
     */
    @SerializedName( "ItemBillingBlockReason" )
    @JsonProperty( "ItemBillingBlockReason" )
    @Nullable
    @ODataField( odataName = "ItemBillingBlockReason" )
    private String itemBillingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>ItemBillingBlockReason</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> ITEM_BILLING_BLOCK_REASON =
        new DebitMemoReqItemSimulationField<String>("ItemBillingBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @return Reason for Rejection of Sales Documents
     */
    @SerializedName( "SalesDocumentRjcnReason" )
    @JsonProperty( "SalesDocumentRjcnReason" )
    @Nullable
    @ODataField( odataName = "SalesDocumentRjcnReason" )
    private String salesDocumentRjcnReason;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentRjcnReason</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> SALES_DOCUMENT_RJCN_REASON =
        new DebitMemoReqItemSimulationField<String>("SalesDocumentRjcnReason");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> PROFIT_CENTER =
        new DebitMemoReqItemSimulationField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @return Document Number of Reference Document
     */
    @SerializedName( "ReferenceSDDocument" )
    @JsonProperty( "ReferenceSDDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocument" )
    private String referenceSDDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocument</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> REFERENCE_SD_DOCUMENT =
        new DebitMemoReqItemSimulationField<String>("ReferenceSDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @return Item Number of the Reference Item
     */
    @SerializedName( "ReferenceSDDocumentItem" )
    @JsonProperty( "ReferenceSDDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentItem" )
    private String referenceSDDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentItem</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<String> REFERENCE_SD_DOCUMENT_ITEM =
        new DebitMemoReqItemSimulationField<String>("ReferenceSDDocumentItem");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal1Amount</b>
     * </p>
     *
     * @return Subtotal 1 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal1Amount" )
    @JsonProperty( "Subtotal1Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal1Amount" )
    private BigDecimal subtotal1Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal1Amount</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<BigDecimal> SUBTOTAL1_AMOUNT =
        new DebitMemoReqItemSimulationField<BigDecimal>("Subtotal1Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal2Amount</b>
     * </p>
     *
     * @return Subtotal 2 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal2Amount" )
    @JsonProperty( "Subtotal2Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal2Amount" )
    private BigDecimal subtotal2Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal2Amount</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<BigDecimal> SUBTOTAL2_AMOUNT =
        new DebitMemoReqItemSimulationField<BigDecimal>("Subtotal2Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal3Amount</b>
     * </p>
     *
     * @return Subtotal 3 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal3Amount" )
    @JsonProperty( "Subtotal3Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal3Amount" )
    private BigDecimal subtotal3Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal3Amount</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<BigDecimal> SUBTOTAL3_AMOUNT =
        new DebitMemoReqItemSimulationField<BigDecimal>("Subtotal3Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal4Amount</b>
     * </p>
     *
     * @return Subtotal 4 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal4Amount" )
    @JsonProperty( "Subtotal4Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal4Amount" )
    private BigDecimal subtotal4Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal4Amount</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<BigDecimal> SUBTOTAL4_AMOUNT =
        new DebitMemoReqItemSimulationField<BigDecimal>("Subtotal4Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal5Amount</b>
     * </p>
     *
     * @return Subtotal 5 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal5Amount" )
    @JsonProperty( "Subtotal5Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal5Amount" )
    private BigDecimal subtotal5Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal5Amount</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<BigDecimal> SUBTOTAL5_AMOUNT =
        new DebitMemoReqItemSimulationField<BigDecimal>("Subtotal5Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal6Amount</b>
     * </p>
     *
     * @return Subtotal 6 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal6Amount" )
    @JsonProperty( "Subtotal6Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal6Amount" )
    private BigDecimal subtotal6Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal6Amount</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<BigDecimal> SUBTOTAL6_AMOUNT =
        new DebitMemoReqItemSimulationField<BigDecimal>("Subtotal6Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmount</b>
     * </p>
     *
     * @return Tax Amount in Document Currency
     */
    @SerializedName( "TaxAmount" )
    @JsonProperty( "TaxAmount" )
    @Nullable
    @ODataField( odataName = "TaxAmount" )
    private BigDecimal taxAmount;
    /**
     * Use with available fluent helpers to apply the <b>TaxAmount</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationField<BigDecimal> TAX_AMOUNT =
        new DebitMemoReqItemSimulationField<BigDecimal>("TaxAmount");
    /**
     * Navigation property <b>to_Partner</b> for <b>DebitMemoReqItemSimulation</b> to multiple
     * <b>DebitMemoReqItemPartnerSimln</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DebitMemoReqItemPartnerSimln> toPartner;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>DebitMemoReqItemSimulation</b> to multiple
     * <b>DebitMemoReqItemPrgElmSimln</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DebitMemoReqItemPrgElmSimln> toPricingElement;
    /**
     * Navigation property <b>to_DebitMemoRequest</b> for <b>DebitMemoReqItemSimulation</b> to single
     * <b>DebitMemoRequestSimulation</b>.
     *
     */
    @SerializedName( "to_DebitMemoRequest" )
    @JsonProperty( "to_DebitMemoRequest" )
    @ODataField( odataName = "to_DebitMemoRequest" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DebitMemoRequestSimulation toDebitMemoRequest;
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationLink<DebitMemoReqItemPartnerSimln> TO_PARTNER =
        new DebitMemoReqItemSimulationLink<DebitMemoReqItemPartnerSimln>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static DebitMemoReqItemSimulationLink<DebitMemoReqItemPrgElmSimln> TO_PRICING_ELEMENT =
        new DebitMemoReqItemSimulationLink<DebitMemoReqItemPrgElmSimln>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_DebitMemoRequest</b> navigation property to query
     * operations.
     *
     */
    public final static DebitMemoReqItemSimulationOneToOneLink<DebitMemoRequestSimulation> TO_DEBIT_MEMO_REQUEST =
        new DebitMemoReqItemSimulationOneToOneLink<DebitMemoRequestSimulation>("to_DebitMemoRequest");

    @Nonnull
    @Override
    public Class<DebitMemoReqItemSimulation> getType()
    {
        return DebitMemoReqItemSimulation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequest</b>
     * </p>
     *
     * @param debitMemoRequest
     *            Debit Memo Request
     */
    public void setDebitMemoRequest( @Nullable final String debitMemoRequest )
    {
        rememberChangedField("DebitMemoRequest", this.debitMemoRequest);
        this.debitMemoRequest = debitMemoRequest;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequestItem</b>
     * </p>
     *
     * @param debitMemoRequestItem
     *            Debit Memo Request Item
     */
    public void setDebitMemoRequestItem( @Nullable final String debitMemoRequestItem )
    {
        rememberChangedField("DebitMemoRequestItem", this.debitMemoRequestItem);
        this.debitMemoRequestItem = debitMemoRequestItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @param higherLevelItem
     *            Higher-Level Item in Bill of Material Structures
     */
    public void setHigherLevelItem( @Nullable final String higherLevelItem )
    {
        rememberChangedField("HigherLevelItem", this.higherLevelItem);
        this.higherLevelItem = higherLevelItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequestItemCategory</b>
     * </p>
     *
     * @param debitMemoRequestItemCategory
     *            Sales Document Item Category
     */
    public void setDebitMemoRequestItemCategory( @Nullable final String debitMemoRequestItemCategory )
    {
        rememberChangedField("DebitMemoRequestItemCategory", this.debitMemoRequestItemCategory);
        this.debitMemoRequestItemCategory = debitMemoRequestItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequestItemText</b>
     * </p>
     *
     * @param debitMemoRequestItemText
     *            Short Text for Sales Order Item
     */
    public void setDebitMemoRequestItemText( @Nullable final String debitMemoRequestItemText )
    {
        rememberChangedField("DebitMemoRequestItemText", this.debitMemoRequestItemText);
        this.debitMemoRequestItemText = debitMemoRequestItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Material Number Used by Customer
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @param pricingDate
     *            Date for Pricing and Exchange Rate
     */
    public void setPricingDate( @Nullable final LocalDateTime pricingDate )
    {
        rememberChangedField("PricingDate", this.pricingDate);
        this.pricingDate = pricingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @param requestedQuantity
     *            Requested Quantity
     */
    public void setRequestedQuantity( @Nullable final BigDecimal requestedQuantity )
    {
        rememberChangedField("RequestedQuantity", this.requestedQuantity);
        this.requestedQuantity = requestedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @param requestedQuantityUnit
     *            Unit of the Requested Quantity
     */
    public void setRequestedQuantityUnit( @Nullable final String requestedQuantityUnit )
    {
        rememberChangedField("RequestedQuantityUnit", this.requestedQuantityUnit);
        this.requestedQuantityUnit = requestedQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantitySAPUnit</b>
     * </p>
     *
     * @param requestedQuantitySAPUnit
     *            SAP Unit Code for Requested Quantity
     */
    public void setRequestedQuantitySAPUnit( @Nullable final String requestedQuantitySAPUnit )
    {
        rememberChangedField("RequestedQuantitySAPUnit", this.requestedQuantitySAPUnit);
        this.requestedQuantitySAPUnit = requestedQuantitySAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityISOUnit</b>
     * </p>
     *
     * @param requestedQuantityISOUnit
     *            ISO Unit Code for Requested Quantity
     */
    public void setRequestedQuantityISOUnit( @Nullable final String requestedQuantityISOUnit )
    {
        rememberChangedField("RequestedQuantityISOUnit", this.requestedQuantityISOUnit);
        this.requestedQuantityISOUnit = requestedQuantityISOUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @param itemGrossWeight
     *            Gross Weight of the Item
     */
    public void setItemGrossWeight( @Nullable final BigDecimal itemGrossWeight )
    {
        rememberChangedField("ItemGrossWeight", this.itemGrossWeight);
        this.itemGrossWeight = itemGrossWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @param itemNetWeight
     *            Net Weight of the Item
     */
    public void setItemNetWeight( @Nullable final BigDecimal itemNetWeight )
    {
        rememberChangedField("ItemNetWeight", this.itemNetWeight);
        this.itemNetWeight = itemNetWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @param itemWeightUnit
     *            Unit of Weight
     */
    public void setItemWeightUnit( @Nullable final String itemWeightUnit )
    {
        rememberChangedField("ItemWeightUnit", this.itemWeightUnit);
        this.itemWeightUnit = itemWeightUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightSAPUnit</b>
     * </p>
     *
     * @param itemWeightSAPUnit
     *            SAP Unit Code for Item Weight
     */
    public void setItemWeightSAPUnit( @Nullable final String itemWeightSAPUnit )
    {
        rememberChangedField("ItemWeightSAPUnit", this.itemWeightSAPUnit);
        this.itemWeightSAPUnit = itemWeightSAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightISOUnit</b>
     * </p>
     *
     * @param itemWeightISOUnit
     *            ISO Unit Code for Item Weight
     */
    public void setItemWeightISOUnit( @Nullable final String itemWeightISOUnit )
    {
        rememberChangedField("ItemWeightISOUnit", this.itemWeightISOUnit);
        this.itemWeightISOUnit = itemWeightISOUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @param itemVolume
     *            Volume of the item
     */
    public void setItemVolume( @Nullable final BigDecimal itemVolume )
    {
        rememberChangedField("ItemVolume", this.itemVolume);
        this.itemVolume = itemVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @param itemVolumeUnit
     *            Volume Unit
     */
    public void setItemVolumeUnit( @Nullable final String itemVolumeUnit )
    {
        rememberChangedField("ItemVolumeUnit", this.itemVolumeUnit);
        this.itemVolumeUnit = itemVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeSAPUnit</b>
     * </p>
     *
     * @param itemVolumeSAPUnit
     *            SAP Unit Code for Item Volume
     */
    public void setItemVolumeSAPUnit( @Nullable final String itemVolumeSAPUnit )
    {
        rememberChangedField("ItemVolumeSAPUnit", this.itemVolumeSAPUnit);
        this.itemVolumeSAPUnit = itemVolumeSAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeISOUnit</b>
     * </p>
     *
     * @param itemVolumeISOUnit
     *            ISO Unit Code for Item Volume
     */
    public void setItemVolumeISOUnit( @Nullable final String itemVolumeISOUnit )
    {
        rememberChangedField("ItemVolumeISOUnit", this.itemVolumeISOUnit);
        this.itemVolumeISOUnit = itemVolumeISOUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Net Value of the Order Item in Document Currency
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup1</b>
     * </p>
     *
     * @param additionalMaterialGroup1
     *            Material Group 1
     */
    public void setAdditionalMaterialGroup1( @Nullable final String additionalMaterialGroup1 )
    {
        rememberChangedField("AdditionalMaterialGroup1", this.additionalMaterialGroup1);
        this.additionalMaterialGroup1 = additionalMaterialGroup1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup2</b>
     * </p>
     *
     * @param additionalMaterialGroup2
     *            Material Group 2
     */
    public void setAdditionalMaterialGroup2( @Nullable final String additionalMaterialGroup2 )
    {
        rememberChangedField("AdditionalMaterialGroup2", this.additionalMaterialGroup2);
        this.additionalMaterialGroup2 = additionalMaterialGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup3</b>
     * </p>
     *
     * @param additionalMaterialGroup3
     *            Material Group 3
     */
    public void setAdditionalMaterialGroup3( @Nullable final String additionalMaterialGroup3 )
    {
        rememberChangedField("AdditionalMaterialGroup3", this.additionalMaterialGroup3);
        this.additionalMaterialGroup3 = additionalMaterialGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup4</b>
     * </p>
     *
     * @param additionalMaterialGroup4
     *            Material Group 4
     */
    public void setAdditionalMaterialGroup4( @Nullable final String additionalMaterialGroup4 )
    {
        rememberChangedField("AdditionalMaterialGroup4", this.additionalMaterialGroup4);
        this.additionalMaterialGroup4 = additionalMaterialGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup5</b>
     * </p>
     *
     * @param additionalMaterialGroup5
     *            Material Group 5
     */
    public void setAdditionalMaterialGroup5( @Nullable final String additionalMaterialGroup5 )
    {
        rememberChangedField("AdditionalMaterialGroup5", this.additionalMaterialGroup5);
        this.additionalMaterialGroup5 = additionalMaterialGroup5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @param materialPricingGroup
     *            Material Price Group
     */
    public void setMaterialPricingGroup( @Nullable final String materialPricingGroup )
    {
        rememberChangedField("MaterialPricingGroup", this.materialPricingGroup);
        this.materialPricingGroup = materialPricingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @param productTaxClassification1
     *            Tax Classification for Material
     */
    public void setProductTaxClassification1( @Nullable final String productTaxClassification1 )
    {
        rememberChangedField("ProductTaxClassification1", this.productTaxClassification1);
        this.productTaxClassification1 = productTaxClassification1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification2</b>
     * </p>
     *
     * @param productTaxClassification2
     *            Tax Classification for Material
     */
    public void setProductTaxClassification2( @Nullable final String productTaxClassification2 )
    {
        rememberChangedField("ProductTaxClassification2", this.productTaxClassification2);
        this.productTaxClassification2 = productTaxClassification2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification3</b>
     * </p>
     *
     * @param productTaxClassification3
     *            Tax Classification for Material
     */
    public void setProductTaxClassification3( @Nullable final String productTaxClassification3 )
    {
        rememberChangedField("ProductTaxClassification3", this.productTaxClassification3);
        this.productTaxClassification3 = productTaxClassification3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification4</b>
     * </p>
     *
     * @param productTaxClassification4
     *            Tax Classification for Material
     */
    public void setProductTaxClassification4( @Nullable final String productTaxClassification4 )
    {
        rememberChangedField("ProductTaxClassification4", this.productTaxClassification4);
        this.productTaxClassification4 = productTaxClassification4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification5</b>
     * </p>
     *
     * @param productTaxClassification5
     *            Tax Classification for Material
     */
    public void setProductTaxClassification5( @Nullable final String productTaxClassification5 )
    {
        rememberChangedField("ProductTaxClassification5", this.productTaxClassification5);
        this.productTaxClassification5 = productTaxClassification5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification6</b>
     * </p>
     *
     * @param productTaxClassification6
     *            Tax Classification for Material
     */
    public void setProductTaxClassification6( @Nullable final String productTaxClassification6 )
    {
        rememberChangedField("ProductTaxClassification6", this.productTaxClassification6);
        this.productTaxClassification6 = productTaxClassification6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification7</b>
     * </p>
     *
     * @param productTaxClassification7
     *            Tax Classification for Material
     */
    public void setProductTaxClassification7( @Nullable final String productTaxClassification7 )
    {
        rememberChangedField("ProductTaxClassification7", this.productTaxClassification7);
        this.productTaxClassification7 = productTaxClassification7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification8</b>
     * </p>
     *
     * @param productTaxClassification8
     *            Tax Classification for Material
     */
    public void setProductTaxClassification8( @Nullable final String productTaxClassification8 )
    {
        rememberChangedField("ProductTaxClassification8", this.productTaxClassification8);
        this.productTaxClassification8 = productTaxClassification8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification9</b>
     * </p>
     *
     * @param productTaxClassification9
     *            Tax Classification for Material
     */
    public void setProductTaxClassification9( @Nullable final String productTaxClassification9 )
    {
        rememberChangedField("ProductTaxClassification9", this.productTaxClassification9);
        this.productTaxClassification9 = productTaxClassification9;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant (Own or External)
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @param customerPaymentTerms
     *            Terms of Payment Key
     */
    public void setCustomerPaymentTerms( @Nullable final String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingBlockReason</b>
     * </p>
     *
     * @param itemBillingBlockReason
     *            Billing Block for Item
     */
    public void setItemBillingBlockReason( @Nullable final String itemBillingBlockReason )
    {
        rememberChangedField("ItemBillingBlockReason", this.itemBillingBlockReason);
        this.itemBillingBlockReason = itemBillingBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @param salesDocumentRjcnReason
     *            Reason for Rejection of Sales Documents
     */
    public void setSalesDocumentRjcnReason( @Nullable final String salesDocumentRjcnReason )
    {
        rememberChangedField("SalesDocumentRjcnReason", this.salesDocumentRjcnReason);
        this.salesDocumentRjcnReason = salesDocumentRjcnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @param referenceSDDocument
     *            Document Number of Reference Document
     */
    public void setReferenceSDDocument( @Nullable final String referenceSDDocument )
    {
        rememberChangedField("ReferenceSDDocument", this.referenceSDDocument);
        this.referenceSDDocument = referenceSDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @param referenceSDDocumentItem
     *            Item Number of the Reference Item
     */
    public void setReferenceSDDocumentItem( @Nullable final String referenceSDDocumentItem )
    {
        rememberChangedField("ReferenceSDDocumentItem", this.referenceSDDocumentItem);
        this.referenceSDDocumentItem = referenceSDDocumentItem;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal1Amount</b>
     * </p>
     *
     * @param subtotal1Amount
     *            Subtotal 1 from Pricing Procedure for Price Element
     */
    public void setSubtotal1Amount( @Nullable final BigDecimal subtotal1Amount )
    {
        rememberChangedField("Subtotal1Amount", this.subtotal1Amount);
        this.subtotal1Amount = subtotal1Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal2Amount</b>
     * </p>
     *
     * @param subtotal2Amount
     *            Subtotal 2 from Pricing Procedure for Price Element
     */
    public void setSubtotal2Amount( @Nullable final BigDecimal subtotal2Amount )
    {
        rememberChangedField("Subtotal2Amount", this.subtotal2Amount);
        this.subtotal2Amount = subtotal2Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal3Amount</b>
     * </p>
     *
     * @param subtotal3Amount
     *            Subtotal 3 from Pricing Procedure for Price Element
     */
    public void setSubtotal3Amount( @Nullable final BigDecimal subtotal3Amount )
    {
        rememberChangedField("Subtotal3Amount", this.subtotal3Amount);
        this.subtotal3Amount = subtotal3Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal4Amount</b>
     * </p>
     *
     * @param subtotal4Amount
     *            Subtotal 4 from Pricing Procedure for Price Element
     */
    public void setSubtotal4Amount( @Nullable final BigDecimal subtotal4Amount )
    {
        rememberChangedField("Subtotal4Amount", this.subtotal4Amount);
        this.subtotal4Amount = subtotal4Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal5Amount</b>
     * </p>
     *
     * @param subtotal5Amount
     *            Subtotal 5 from Pricing Procedure for Price Element
     */
    public void setSubtotal5Amount( @Nullable final BigDecimal subtotal5Amount )
    {
        rememberChangedField("Subtotal5Amount", this.subtotal5Amount);
        this.subtotal5Amount = subtotal5Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal6Amount</b>
     * </p>
     *
     * @param subtotal6Amount
     *            Subtotal 6 from Pricing Procedure for Price Element
     */
    public void setSubtotal6Amount( @Nullable final BigDecimal subtotal6Amount )
    {
        rememberChangedField("Subtotal6Amount", this.subtotal6Amount);
        this.subtotal6Amount = subtotal6Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmount</b>
     * </p>
     *
     * @param taxAmount
     *            Tax Amount in Document Currency
     */
    public void setTaxAmount( @Nullable final BigDecimal taxAmount )
    {
        rememberChangedField("TaxAmount", this.taxAmount);
        this.taxAmount = taxAmount;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DebitMemoReqItemSimulation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DebitMemoRequest", getDebitMemoRequest());
        result.put("DebitMemoRequestItem", getDebitMemoRequestItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DebitMemoRequest", getDebitMemoRequest());
        values.put("DebitMemoRequestItem", getDebitMemoRequestItem());
        values.put("HigherLevelItem", getHigherLevelItem());
        values.put("DebitMemoRequestItemCategory", getDebitMemoRequestItemCategory());
        values.put("DebitMemoRequestItemText", getDebitMemoRequestItemText());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("Material", getMaterial());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("PricingDate", getPricingDate());
        values.put("RequestedQuantity", getRequestedQuantity());
        values.put("RequestedQuantityUnit", getRequestedQuantityUnit());
        values.put("RequestedQuantitySAPUnit", getRequestedQuantitySAPUnit());
        values.put("RequestedQuantityISOUnit", getRequestedQuantityISOUnit());
        values.put("ItemGrossWeight", getItemGrossWeight());
        values.put("ItemNetWeight", getItemNetWeight());
        values.put("ItemWeightUnit", getItemWeightUnit());
        values.put("ItemWeightSAPUnit", getItemWeightSAPUnit());
        values.put("ItemWeightISOUnit", getItemWeightISOUnit());
        values.put("ItemVolume", getItemVolume());
        values.put("ItemVolumeUnit", getItemVolumeUnit());
        values.put("ItemVolumeSAPUnit", getItemVolumeSAPUnit());
        values.put("ItemVolumeISOUnit", getItemVolumeISOUnit());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("NetAmount", getNetAmount());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("AdditionalMaterialGroup1", getAdditionalMaterialGroup1());
        values.put("AdditionalMaterialGroup2", getAdditionalMaterialGroup2());
        values.put("AdditionalMaterialGroup3", getAdditionalMaterialGroup3());
        values.put("AdditionalMaterialGroup4", getAdditionalMaterialGroup4());
        values.put("AdditionalMaterialGroup5", getAdditionalMaterialGroup5());
        values.put("MaterialPricingGroup", getMaterialPricingGroup());
        values.put("ProductTaxClassification1", getProductTaxClassification1());
        values.put("ProductTaxClassification2", getProductTaxClassification2());
        values.put("ProductTaxClassification3", getProductTaxClassification3());
        values.put("ProductTaxClassification4", getProductTaxClassification4());
        values.put("ProductTaxClassification5", getProductTaxClassification5());
        values.put("ProductTaxClassification6", getProductTaxClassification6());
        values.put("ProductTaxClassification7", getProductTaxClassification7());
        values.put("ProductTaxClassification8", getProductTaxClassification8());
        values.put("ProductTaxClassification9", getProductTaxClassification9());
        values.put("Batch", getBatch());
        values.put("Plant", getPlant());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("ItemBillingBlockReason", getItemBillingBlockReason());
        values.put("SalesDocumentRjcnReason", getSalesDocumentRjcnReason());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ReferenceSDDocument", getReferenceSDDocument());
        values.put("ReferenceSDDocumentItem", getReferenceSDDocumentItem());
        values.put("Subtotal1Amount", getSubtotal1Amount());
        values.put("Subtotal2Amount", getSubtotal2Amount());
        values.put("Subtotal3Amount", getSubtotal3Amount());
        values.put("Subtotal4Amount", getSubtotal4Amount());
        values.put("Subtotal5Amount", getSubtotal5Amount());
        values.put("Subtotal6Amount", getSubtotal6Amount());
        values.put("TaxAmount", getTaxAmount());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DebitMemoRequest") ) {
                final Object value = values.remove("DebitMemoRequest");
                if( (value == null) || (!value.equals(getDebitMemoRequest())) ) {
                    setDebitMemoRequest(((String) value));
                }
            }
            if( values.containsKey("DebitMemoRequestItem") ) {
                final Object value = values.remove("DebitMemoRequestItem");
                if( (value == null) || (!value.equals(getDebitMemoRequestItem())) ) {
                    setDebitMemoRequestItem(((String) value));
                }
            }
            if( values.containsKey("HigherLevelItem") ) {
                final Object value = values.remove("HigherLevelItem");
                if( (value == null) || (!value.equals(getHigherLevelItem())) ) {
                    setHigherLevelItem(((String) value));
                }
            }
            if( values.containsKey("DebitMemoRequestItemCategory") ) {
                final Object value = values.remove("DebitMemoRequestItemCategory");
                if( (value == null) || (!value.equals(getDebitMemoRequestItemCategory())) ) {
                    setDebitMemoRequestItemCategory(((String) value));
                }
            }
            if( values.containsKey("DebitMemoRequestItemText") ) {
                final Object value = values.remove("DebitMemoRequestItemText");
                if( (value == null) || (!value.equals(getDebitMemoRequestItemText())) ) {
                    setDebitMemoRequestItemText(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("PricingDate") ) {
                final Object value = values.remove("PricingDate");
                if( (value == null) || (!value.equals(getPricingDate())) ) {
                    setPricingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RequestedQuantity") ) {
                final Object value = values.remove("RequestedQuantity");
                if( (value == null) || (!value.equals(getRequestedQuantity())) ) {
                    setRequestedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("RequestedQuantityUnit") ) {
                final Object value = values.remove("RequestedQuantityUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityUnit())) ) {
                    setRequestedQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantitySAPUnit") ) {
                final Object value = values.remove("RequestedQuantitySAPUnit");
                if( (value == null) || (!value.equals(getRequestedQuantitySAPUnit())) ) {
                    setRequestedQuantitySAPUnit(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantityISOUnit") ) {
                final Object value = values.remove("RequestedQuantityISOUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityISOUnit())) ) {
                    setRequestedQuantityISOUnit(((String) value));
                }
            }
            if( values.containsKey("ItemGrossWeight") ) {
                final Object value = values.remove("ItemGrossWeight");
                if( (value == null) || (!value.equals(getItemGrossWeight())) ) {
                    setItemGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemNetWeight") ) {
                final Object value = values.remove("ItemNetWeight");
                if( (value == null) || (!value.equals(getItemNetWeight())) ) {
                    setItemNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemWeightUnit") ) {
                final Object value = values.remove("ItemWeightUnit");
                if( (value == null) || (!value.equals(getItemWeightUnit())) ) {
                    setItemWeightUnit(((String) value));
                }
            }
            if( values.containsKey("ItemWeightSAPUnit") ) {
                final Object value = values.remove("ItemWeightSAPUnit");
                if( (value == null) || (!value.equals(getItemWeightSAPUnit())) ) {
                    setItemWeightSAPUnit(((String) value));
                }
            }
            if( values.containsKey("ItemWeightISOUnit") ) {
                final Object value = values.remove("ItemWeightISOUnit");
                if( (value == null) || (!value.equals(getItemWeightISOUnit())) ) {
                    setItemWeightISOUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolume") ) {
                final Object value = values.remove("ItemVolume");
                if( (value == null) || (!value.equals(getItemVolume())) ) {
                    setItemVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemVolumeUnit") ) {
                final Object value = values.remove("ItemVolumeUnit");
                if( (value == null) || (!value.equals(getItemVolumeUnit())) ) {
                    setItemVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolumeSAPUnit") ) {
                final Object value = values.remove("ItemVolumeSAPUnit");
                if( (value == null) || (!value.equals(getItemVolumeSAPUnit())) ) {
                    setItemVolumeSAPUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolumeISOUnit") ) {
                final Object value = values.remove("ItemVolumeISOUnit");
                if( (value == null) || (!value.equals(getItemVolumeISOUnit())) ) {
                    setItemVolumeISOUnit(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup1") ) {
                final Object value = values.remove("AdditionalMaterialGroup1");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup1())) ) {
                    setAdditionalMaterialGroup1(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup2") ) {
                final Object value = values.remove("AdditionalMaterialGroup2");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup2())) ) {
                    setAdditionalMaterialGroup2(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup3") ) {
                final Object value = values.remove("AdditionalMaterialGroup3");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup3())) ) {
                    setAdditionalMaterialGroup3(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup4") ) {
                final Object value = values.remove("AdditionalMaterialGroup4");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup4())) ) {
                    setAdditionalMaterialGroup4(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup5") ) {
                final Object value = values.remove("AdditionalMaterialGroup5");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup5())) ) {
                    setAdditionalMaterialGroup5(((String) value));
                }
            }
            if( values.containsKey("MaterialPricingGroup") ) {
                final Object value = values.remove("MaterialPricingGroup");
                if( (value == null) || (!value.equals(getMaterialPricingGroup())) ) {
                    setMaterialPricingGroup(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification1") ) {
                final Object value = values.remove("ProductTaxClassification1");
                if( (value == null) || (!value.equals(getProductTaxClassification1())) ) {
                    setProductTaxClassification1(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification2") ) {
                final Object value = values.remove("ProductTaxClassification2");
                if( (value == null) || (!value.equals(getProductTaxClassification2())) ) {
                    setProductTaxClassification2(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification3") ) {
                final Object value = values.remove("ProductTaxClassification3");
                if( (value == null) || (!value.equals(getProductTaxClassification3())) ) {
                    setProductTaxClassification3(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification4") ) {
                final Object value = values.remove("ProductTaxClassification4");
                if( (value == null) || (!value.equals(getProductTaxClassification4())) ) {
                    setProductTaxClassification4(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification5") ) {
                final Object value = values.remove("ProductTaxClassification5");
                if( (value == null) || (!value.equals(getProductTaxClassification5())) ) {
                    setProductTaxClassification5(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification6") ) {
                final Object value = values.remove("ProductTaxClassification6");
                if( (value == null) || (!value.equals(getProductTaxClassification6())) ) {
                    setProductTaxClassification6(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification7") ) {
                final Object value = values.remove("ProductTaxClassification7");
                if( (value == null) || (!value.equals(getProductTaxClassification7())) ) {
                    setProductTaxClassification7(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification8") ) {
                final Object value = values.remove("ProductTaxClassification8");
                if( (value == null) || (!value.equals(getProductTaxClassification8())) ) {
                    setProductTaxClassification8(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification9") ) {
                final Object value = values.remove("ProductTaxClassification9");
                if( (value == null) || (!value.equals(getProductTaxClassification9())) ) {
                    setProductTaxClassification9(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("ItemBillingBlockReason") ) {
                final Object value = values.remove("ItemBillingBlockReason");
                if( (value == null) || (!value.equals(getItemBillingBlockReason())) ) {
                    setItemBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentRjcnReason") ) {
                final Object value = values.remove("SalesDocumentRjcnReason");
                if( (value == null) || (!value.equals(getSalesDocumentRjcnReason())) ) {
                    setSalesDocumentRjcnReason(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocument") ) {
                final Object value = values.remove("ReferenceSDDocument");
                if( (value == null) || (!value.equals(getReferenceSDDocument())) ) {
                    setReferenceSDDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentItem") ) {
                final Object value = values.remove("ReferenceSDDocumentItem");
                if( (value == null) || (!value.equals(getReferenceSDDocumentItem())) ) {
                    setReferenceSDDocumentItem(((String) value));
                }
            }
            if( values.containsKey("Subtotal1Amount") ) {
                final Object value = values.remove("Subtotal1Amount");
                if( (value == null) || (!value.equals(getSubtotal1Amount())) ) {
                    setSubtotal1Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal2Amount") ) {
                final Object value = values.remove("Subtotal2Amount");
                if( (value == null) || (!value.equals(getSubtotal2Amount())) ) {
                    setSubtotal2Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal3Amount") ) {
                final Object value = values.remove("Subtotal3Amount");
                if( (value == null) || (!value.equals(getSubtotal3Amount())) ) {
                    setSubtotal3Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal4Amount") ) {
                final Object value = values.remove("Subtotal4Amount");
                if( (value == null) || (!value.equals(getSubtotal4Amount())) ) {
                    setSubtotal4Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal5Amount") ) {
                final Object value = values.remove("Subtotal5Amount");
                if( (value == null) || (!value.equals(getSubtotal5Amount())) ) {
                    setSubtotal5Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal6Amount") ) {
                final Object value = values.remove("Subtotal6Amount");
                if( (value == null) || (!value.equals(getSubtotal6Amount())) ) {
                    setSubtotal6Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxAmount") ) {
                final Object value = values.remove("TaxAmount");
                if( (value == null) || (!value.equals(getTaxAmount())) ) {
                    setTaxAmount(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DebitMemoReqItemPartnerSimln entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new DebitMemoReqItemPartnerSimln();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DebitMemoReqItemPrgElmSimln entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new DebitMemoReqItemPrgElmSimln();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_DebitMemoRequest") ) {
                final Object value = (values).remove("to_DebitMemoRequest");
                if( value instanceof Map ) {
                    if( toDebitMemoRequest == null ) {
                        toDebitMemoRequest = new DebitMemoRequestSimulation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toDebitMemoRequest.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> DebitMemoReqItemSimulationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new DebitMemoReqItemSimulationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DebitMemoReqItemSimulationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DebitMemoReqItemSimulationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestSimulateService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toDebitMemoRequest != null ) {
            (values).put("to_DebitMemoRequest", toDebitMemoRequest);
        }
        return values;
    }

    /**
     * Fetches the <b>DebitMemoReqItemPartnerSimln</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DebitMemoReqItemPartnerSimln</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DebitMemoReqItemPartnerSimln> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", DebitMemoReqItemPartnerSimln.class);
    }

    /**
     * Retrieval of associated <b>DebitMemoReqItemPartnerSimln</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>DebitMemoReqItemSimulation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DebitMemoReqItemPartnerSimln</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DebitMemoReqItemPartnerSimln> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>DebitMemoReqItemPartnerSimln</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>DebitMemoReqItemSimulation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>DebitMemoReqItemPartnerSimln</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DebitMemoReqItemPartnerSimln>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>DebitMemoReqItemPartnerSimln</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>DebitMemoReqItemSimulation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DebitMemoReqItemPartnerSimln</b> entities.
     */
    public void setPartner( @Nonnull final List<DebitMemoReqItemPartnerSimln> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DebitMemoReqItemPartnerSimln</b> entities. This corresponds to the
     * OData navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>DebitMemoReqItemSimulation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DebitMemoReqItemPartnerSimln</b> entities.
     */
    public void addPartner( DebitMemoReqItemPartnerSimln... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>DebitMemoReqItemPrgElmSimln</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DebitMemoReqItemPrgElmSimln</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DebitMemoReqItemPrgElmSimln> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", DebitMemoReqItemPrgElmSimln.class);
    }

    /**
     * Retrieval of associated <b>DebitMemoReqItemPrgElmSimln</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>DebitMemoReqItemSimulation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DebitMemoReqItemPrgElmSimln</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DebitMemoReqItemPrgElmSimln> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>DebitMemoReqItemPrgElmSimln</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>DebitMemoReqItemSimulation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>DebitMemoReqItemPrgElmSimln</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DebitMemoReqItemPrgElmSimln>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>DebitMemoReqItemPrgElmSimln</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>DebitMemoReqItemSimulation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DebitMemoReqItemPrgElmSimln</b> entities.
     */
    public void setPricingElement( @Nonnull final List<DebitMemoReqItemPrgElmSimln> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DebitMemoReqItemPrgElmSimln</b> entities. This corresponds to the
     * OData navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>DebitMemoReqItemSimulation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DebitMemoReqItemPrgElmSimln</b> entities.
     */
    public void addPricingElement( DebitMemoReqItemPrgElmSimln... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>DebitMemoRequestSimulation</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_DebitMemoRequest</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>DebitMemoRequestSimulation</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DebitMemoRequestSimulation fetchDebitMemoRequest()
    {
        return fetchFieldAsSingle("to_DebitMemoRequest", DebitMemoRequestSimulation.class);
    }

    /**
     * Retrieval of associated <b>DebitMemoRequestSimulation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_DebitMemoRequest</b>.
     * <p>
     * If the navigation property <b>to_DebitMemoRequest</b> of a queried <b>DebitMemoReqItemSimulation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DebitMemoRequestSimulation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DebitMemoRequestSimulation getDebitMemoRequestOrFetch()
    {
        if( toDebitMemoRequest == null ) {
            toDebitMemoRequest = fetchDebitMemoRequest();
        }
        return toDebitMemoRequest;
    }

    /**
     * Retrieval of associated <b>DebitMemoRequestSimulation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_DebitMemoRequest</b>.
     * <p>
     * If the navigation property for an entity <b>DebitMemoReqItemSimulation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_DebitMemoRequest</b> is already loaded, the result will
     *         contain the <b>DebitMemoRequestSimulation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<DebitMemoRequestSimulation> getDebitMemoRequestIfPresent()
    {
        return Option.of(toDebitMemoRequest);
    }

    /**
     * Overwrites the associated <b>DebitMemoRequestSimulation</b> entity for the loaded navigation property
     * <b>to_DebitMemoRequest</b>.
     *
     * @param value
     *            New <b>DebitMemoRequestSimulation</b> entity.
     */
    public void setDebitMemoRequest( final DebitMemoRequestSimulation value )
    {
        toDebitMemoRequest = value;
    }

    /**
     * Helper class to allow for fluent creation of DebitMemoReqItemSimulation instances.
     *
     */
    public final static class DebitMemoReqItemSimulationBuilder
    {

        private List<DebitMemoReqItemPartnerSimln> toPartner = Lists.newArrayList();
        private List<DebitMemoReqItemPrgElmSimln> toPricingElement = Lists.newArrayList();
        private DebitMemoRequestSimulation toDebitMemoRequest;
        private String debitMemoRequest = null;

        private DebitMemoReqItemSimulation.DebitMemoReqItemSimulationBuilder toPartner(
            final List<DebitMemoReqItemPartnerSimln> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>DebitMemoReqItemSimulation</b> to multiple
         * <b>DebitMemoReqItemPartnerSimln</b>.
         *
         * @param value
         *            The DebitMemoReqItemPartnerSimlns to build this DebitMemoReqItemSimulation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DebitMemoReqItemSimulation.DebitMemoReqItemSimulationBuilder partner(
            DebitMemoReqItemPartnerSimln... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private DebitMemoReqItemSimulation.DebitMemoReqItemSimulationBuilder toPricingElement(
            final List<DebitMemoReqItemPrgElmSimln> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>DebitMemoReqItemSimulation</b> to multiple
         * <b>DebitMemoReqItemPrgElmSimln</b>.
         *
         * @param value
         *            The DebitMemoReqItemPrgElmSimlns to build this DebitMemoReqItemSimulation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DebitMemoReqItemSimulation.DebitMemoReqItemSimulationBuilder pricingElement(
            DebitMemoReqItemPrgElmSimln... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private DebitMemoReqItemSimulation.DebitMemoReqItemSimulationBuilder toDebitMemoRequest(
            final DebitMemoRequestSimulation value )
        {
            toDebitMemoRequest = value;
            return this;
        }

        /**
         * Navigation property <b>to_DebitMemoRequest</b> for <b>DebitMemoReqItemSimulation</b> to single
         * <b>DebitMemoRequestSimulation</b>.
         *
         * @param value
         *            The DebitMemoRequestSimulation to build this DebitMemoReqItemSimulation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DebitMemoReqItemSimulation.DebitMemoReqItemSimulationBuilder debitMemoRequest(
            final DebitMemoRequestSimulation value )
        {
            return toDebitMemoRequest(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>DebitMemoRequest</b>
         * </p>
         *
         * @param value
         *            The debitMemoRequest to build this DebitMemoReqItemSimulation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DebitMemoReqItemSimulation.DebitMemoReqItemSimulationBuilder debitMemoRequest( final String value )
        {
            debitMemoRequest = value;
            return this;
        }

    }

}
