/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoRequestSimulation;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestSimulateService
 * DebitMemoRequestSimulateService}.
 *
 */
public interface DebitMemoRequestSimulateServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<DebitMemoRequestSimulateServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<DebitMemoRequestSimulateServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoRequestSimulation
     * DebitMemoRequestSimulation} entity and save it to the S/4HANA system.
     *
     * @param debitMemoRequestSimulation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoRequestSimulation
     *            DebitMemoRequestSimulation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestSimulateServiceBatchChangeSet
        createDebitMemoRequestSimulation( @Nonnull final DebitMemoRequestSimulation debitMemoRequestSimulation );

}
