/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link DebitMemoRequestSimulateServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestSimulateService
 * DebitMemoRequestSimulateService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultDebitMemoRequestSimulateServiceBatch
    extends
    BatchFluentHelperBasic<DebitMemoRequestSimulateServiceBatch, DebitMemoRequestSimulateServiceBatchChangeSet>
    implements
    DebitMemoRequestSimulateServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestSimulateService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultDebitMemoRequestSimulateServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDebitMemoRequestSimulateServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestSimulateService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestSimulateService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultDebitMemoRequestSimulateServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDebitMemoRequestSimulateServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestSimulateService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultDebitMemoRequestSimulateServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public DebitMemoRequestSimulateServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultDebitMemoRequestSimulateServiceBatchChangeSet(this, service);
    }

}
