/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoRequestSimulation;

/**
 * Implementation of the {@link DebitMemoRequestSimulateServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestSimulateService
 * DebitMemoRequestSimulateService}.
 *
 */
public class DefaultDebitMemoRequestSimulateServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<DebitMemoRequestSimulateServiceBatch, DebitMemoRequestSimulateServiceBatchChangeSet>
    implements
    DebitMemoRequestSimulateServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestSimulateService service;

    @SuppressWarnings( "deprecation" )
    DefaultDebitMemoRequestSimulateServiceBatchChangeSet(
        @Nonnull final DefaultDebitMemoRequestSimulateServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestSimulateService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultDebitMemoRequestSimulateServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public DebitMemoRequestSimulateServiceBatchChangeSet createDebitMemoRequestSimulation(
        @Nonnull final DebitMemoRequestSimulation debitMemoRequestSimulation )
    {
        return addRequestCreate(service::createDebitMemoRequestSimulation, debitMemoRequestSimulation);
    }

}
