/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoReqCreditSimulation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoReqCreditSimulation
 * DebitMemoReqCreditSimulation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.field.DebitMemoReqCreditSimulationField
 * DebitMemoReqCreditSimulationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.link.DebitMemoReqCreditSimulationLink
 * DebitMemoReqCreditSimulationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoReqCreditSimulation#DEBIT_MEMO_REQUEST
 * DEBIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoReqCreditSimulation#TOTAL_CREDIT_CHECK_STATUS
 * TOTAL_CREDIT_CHECK_STATUS}</li>
 * </ul>
 *
 */
public interface DebitMemoReqCreditSimulationSelectable extends EntitySelectable<DebitMemoReqCreditSimulation>
{

}
