/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoReqPartnerSimln;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoReqPartnerSimln
 * DebitMemoReqPartnerSimln}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.field.DebitMemoReqPartnerSimlnField
 * DebitMemoReqPartnerSimlnField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.link.DebitMemoReqPartnerSimlnLink
 * DebitMemoReqPartnerSimlnLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoReqPartnerSimln#DEBIT_MEMO_REQUEST
 * DEBIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoReqPartnerSimln#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoReqPartnerSimln#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoReqPartnerSimln#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoReqPartnerSimln#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoReqPartnerSimln#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * </ul>
 *
 */
public interface DebitMemoReqPartnerSimlnSelectable extends EntitySelectable<DebitMemoReqPartnerSimln>
{

}
