/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.field.ControllingDebitCreditCodeTField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.link.ControllingDebitCreditCodeTOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.selectable.ControllingDebitCreditCodeTSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Controlling Debit or Credit Indicator Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ControllingDebitCreditCodeTType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ControllingDebitCreditCodeT extends VdmEntity<ControllingDebitCreditCodeT>
{

    /**
     * Selector for all available fields of ControllingDebitCreditCodeT.
     *
     */
    public final static ControllingDebitCreditCodeTSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ControllingDebitCreditCode</b>
     * </p>
     *
     * @return CO Debit/Credit Indicator
     */
    @Key
    @SerializedName( "ControllingDebitCreditCode" )
    @JsonProperty( "ControllingDebitCreditCode" )
    @Nullable
    @ODataField( odataName = "ControllingDebitCreditCode" )
    private String controllingDebitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>ControllingDebitCreditCode</b> field to query operations.
     *
     */
    public final static ControllingDebitCreditCodeTField<String> CONTROLLING_DEBIT_CREDIT_CODE =
        new ControllingDebitCreditCodeTField<String>("ControllingDebitCreditCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ControllingDebitCreditCodeTField<String> LANGUAGE =
        new ControllingDebitCreditCodeTField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ControllingDebitCreditCodeName</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "ControllingDebitCreditCodeName" )
    @JsonProperty( "ControllingDebitCreditCodeName" )
    @Nullable
    @ODataField( odataName = "ControllingDebitCreditCodeName" )
    private String controllingDebitCreditCodeName;
    /**
     * Use with available fluent helpers to apply the <b>ControllingDebitCreditCodeName</b> field to query operations.
     *
     */
    public final static ControllingDebitCreditCodeTField<String> CONTROLLING_DEBIT_CREDIT_CODE_NAME =
        new ControllingDebitCreditCodeTField<String>("ControllingDebitCreditCodeName");
    /**
     * Navigation property <b>to_ControllingDebitCreditCode</b> for <b>ControllingDebitCreditCodeT</b> to single
     * <b>ControllingDebitCreditCode</b>.
     *
     */
    @SerializedName( "to_ControllingDebitCreditCode" )
    @JsonProperty( "to_ControllingDebitCreditCode" )
    @ODataField( odataName = "to_ControllingDebitCreditCode" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ControllingDebitCreditCode toControllingDebitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>to_ControllingDebitCreditCode</b> navigation property to query
     * operations.
     *
     */
    public final static ControllingDebitCreditCodeTOneToOneLink<ControllingDebitCreditCode> TO_CONTROLLING_DEBIT_CREDIT_CODE =
        new ControllingDebitCreditCodeTOneToOneLink<ControllingDebitCreditCode>("to_ControllingDebitCreditCode");

    @Nonnull
    @Override
    public Class<ControllingDebitCreditCodeT> getType()
    {
        return ControllingDebitCreditCodeT.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ControllingDebitCreditCode</b>
     * </p>
     *
     * @param controllingDebitCreditCode
     *            CO Debit/Credit Indicator
     */
    public void setControllingDebitCreditCode( @Nullable final String controllingDebitCreditCode )
    {
        rememberChangedField("ControllingDebitCreditCode", this.controllingDebitCreditCode);
        this.controllingDebitCreditCode = controllingDebitCreditCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ControllingDebitCreditCodeName</b>
     * </p>
     *
     * @param controllingDebitCreditCodeName
     *            Short Text for Fixed Values
     */
    public void setControllingDebitCreditCodeName( @Nullable final String controllingDebitCreditCodeName )
    {
        rememberChangedField("ControllingDebitCreditCodeName", this.controllingDebitCreditCodeName);
        this.controllingDebitCreditCodeName = controllingDebitCreditCodeName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ControllingDebitCreditCodeT";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ControllingDebitCreditCode", getControllingDebitCreditCode());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ControllingDebitCreditCode", getControllingDebitCreditCode());
        values.put("Language", getLanguage());
        values.put("ControllingDebitCreditCodeName", getControllingDebitCreditCodeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ControllingDebitCreditCode") ) {
                final Object value = values.remove("ControllingDebitCreditCode");
                if( (value == null) || (!value.equals(getControllingDebitCreditCode())) ) {
                    setControllingDebitCreditCode(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ControllingDebitCreditCodeName") ) {
                final Object value = values.remove("ControllingDebitCreditCodeName");
                if( (value == null) || (!value.equals(getControllingDebitCreditCodeName())) ) {
                    setControllingDebitCreditCodeName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ControllingDebitCreditCode") ) {
                final Object value = (values).remove("to_ControllingDebitCreditCode");
                if( value instanceof Map ) {
                    if( toControllingDebitCreditCode == null ) {
                        toControllingDebitCreditCode = new ControllingDebitCreditCode();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toControllingDebitCreditCode.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ControllingDebitCreditCodeTField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ControllingDebitCreditCodeTField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ControllingDebitCreditCodeTField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ControllingDebitCreditCodeTField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitOrCreditIndicatorService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toControllingDebitCreditCode != null ) {
            (values).put("to_ControllingDebitCreditCode", toControllingDebitCreditCode);
        }
        return values;
    }

    /**
     * Fetches the <b>ControllingDebitCreditCode</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ControllingDebitCreditCode</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ControllingDebitCreditCode</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ControllingDebitCreditCode fetchControllingDebitCreditCode()
    {
        return fetchFieldAsSingle("to_ControllingDebitCreditCode", ControllingDebitCreditCode.class);
    }

    /**
     * Retrieval of associated <b>ControllingDebitCreditCode</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ControllingDebitCreditCode</b>.
     * <p>
     * If the navigation property <b>to_ControllingDebitCreditCode</b> of a queried <b>ControllingDebitCreditCodeT</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ControllingDebitCreditCode</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ControllingDebitCreditCode getControllingDebitCreditCodeOrFetch()
    {
        if( toControllingDebitCreditCode == null ) {
            toControllingDebitCreditCode = fetchControllingDebitCreditCode();
        }
        return toControllingDebitCreditCode;
    }

    /**
     * Retrieval of associated <b>ControllingDebitCreditCode</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ControllingDebitCreditCode</b>.
     * <p>
     * If the navigation property for an entity <b>ControllingDebitCreditCodeT</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ControllingDebitCreditCode</b> is already loaded, the
     *         result will contain the <b>ControllingDebitCreditCode</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ControllingDebitCreditCode> getControllingDebitCreditCodeIfPresent()
    {
        return Option.of(toControllingDebitCreditCode);
    }

    /**
     * Overwrites the associated <b>ControllingDebitCreditCode</b> entity for the loaded navigation property
     * <b>to_ControllingDebitCreditCode</b>.
     *
     * @param value
     *            New <b>ControllingDebitCreditCode</b> entity.
     */
    public void setControllingDebitCreditCode( final ControllingDebitCreditCode value )
    {
        toControllingDebitCreditCode = value;
    }

    /**
     * Helper class to allow for fluent creation of ControllingDebitCreditCodeT instances.
     *
     */
    public final static class ControllingDebitCreditCodeTBuilder
    {

        private ControllingDebitCreditCode toControllingDebitCreditCode;
        private String controllingDebitCreditCode = null;

        private ControllingDebitCreditCodeT.ControllingDebitCreditCodeTBuilder toControllingDebitCreditCode(
            final ControllingDebitCreditCode value )
        {
            toControllingDebitCreditCode = value;
            return this;
        }

        /**
         * Navigation property <b>to_ControllingDebitCreditCode</b> for <b>ControllingDebitCreditCodeT</b> to single
         * <b>ControllingDebitCreditCode</b>.
         *
         * @param value
         *            The ControllingDebitCreditCode to build this ControllingDebitCreditCodeT with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ControllingDebitCreditCodeT.ControllingDebitCreditCodeTBuilder controllingDebitCreditCode(
            final ControllingDebitCreditCode value )
        {
            return toControllingDebitCreditCode(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 1
         * <p>
         * Original property name from the Odata EDM: <b>ControllingDebitCreditCode</b>
         * </p>
         *
         * @param value
         *            The controllingDebitCreditCode to build this ControllingDebitCreditCodeT with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ControllingDebitCreditCodeT.ControllingDebitCreditCodeTBuilder controllingDebitCreditCode(
            final String value )
        {
            controllingDebitCreditCode = value;
            return this;
        }

    }

}
