/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.selectable.ControllingDebitCreditCodeTSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.ControllingDebitCreditCodeT
 * ControllingDebitCreditCodeT} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ControllingDebitCreditCodeTByKeyFluentHelper
    extends
    FluentHelperByKey<ControllingDebitCreditCodeTByKeyFluentHelper, ControllingDebitCreditCodeT, ControllingDebitCreditCodeTSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.ControllingDebitCreditCodeT
     * ControllingDebitCreditCodeT} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ControllingDebitCreditCodeT}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ControllingDebitCreditCodeT}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param controllingDebitCreditCode
     *            CO Debit/Credit Indicator
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public ControllingDebitCreditCodeTByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String controllingDebitCreditCode,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("ControllingDebitCreditCode", controllingDebitCreditCode);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<ControllingDebitCreditCodeT> getEntityClass()
    {
        return ControllingDebitCreditCodeT.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
