/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link DebitOrCreditIndicatorServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitOrCreditIndicatorService
 * DebitOrCreditIndicatorService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultDebitOrCreditIndicatorServiceBatch
    extends
    BatchFluentHelperBasic<DebitOrCreditIndicatorServiceBatch, DebitOrCreditIndicatorServiceBatchChangeSet>
    implements
    DebitOrCreditIndicatorServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitOrCreditIndicatorService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultDebitOrCreditIndicatorServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDebitOrCreditIndicatorServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitOrCreditIndicatorService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitOrCreditIndicatorService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultDebitOrCreditIndicatorServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDebitOrCreditIndicatorServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitOrCreditIndicatorService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultDebitOrCreditIndicatorServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public DebitOrCreditIndicatorServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultDebitOrCreditIndicatorServiceBatchChangeSet(this, service);
    }

}
