/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link DebitOrCreditIndicatorServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitOrCreditIndicatorService
 * DebitOrCreditIndicatorService}.
 *
 */
public class DefaultDebitOrCreditIndicatorServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<DebitOrCreditIndicatorServiceBatch, DebitOrCreditIndicatorServiceBatchChangeSet>
    implements
    DebitOrCreditIndicatorServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitOrCreditIndicatorService service;

    @SuppressWarnings( "deprecation" )
    DefaultDebitOrCreditIndicatorServiceBatchChangeSet(
        @Nonnull final DefaultDebitOrCreditIndicatorServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitOrCreditIndicatorService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultDebitOrCreditIndicatorServiceBatchChangeSet getThis()
    {
        return this;
    }

}
