/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.ControllingDebitCreditCodeT;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.selectable.ControllingDebitCreditCodeTSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.ControllingDebitCreditCodeT
 * ControllingDebitCreditCodeT} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class ControllingDebitCreditCodeTLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<ControllingDebitCreditCodeTLink<ObjectT>, ControllingDebitCreditCodeT, ObjectT>
    implements
    ControllingDebitCreditCodeTSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public ControllingDebitCreditCodeTLink( final String fieldName )
    {
        super(fieldName);
    }

    private ControllingDebitCreditCodeTLink(
        final EntityLink<ControllingDebitCreditCodeTLink<ObjectT>, ControllingDebitCreditCodeT, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected ControllingDebitCreditCodeTLink<ObjectT> translateLinkType(
        final EntityLink<ControllingDebitCreditCodeTLink<ObjectT>, ControllingDebitCreditCodeT, ObjectT> link )
    {
        return new ControllingDebitCreditCodeTLink<ObjectT>(link);
    }

}
