/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.ControllingDebitCreditCode;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.ControllingDebitCreditCode
 * ControllingDebitCreditCode}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.field.ControllingDebitCreditCodeField
 * ControllingDebitCreditCodeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.link.ControllingDebitCreditCodeLink
 * ControllingDebitCreditCodeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.ControllingDebitCreditCode#CONTROLLING_DEBIT_CREDIT_CODE
 * CONTROLLING_DEBIT_CREDIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.ControllingDebitCreditCode#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface ControllingDebitCreditCodeSelectable extends EntitySelectable<ControllingDebitCreditCode>
{

}
