/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.ControllingDebitCreditCodeT;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.ControllingDebitCreditCodeT
 * ControllingDebitCreditCodeT}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.field.ControllingDebitCreditCodeTField
 * ControllingDebitCreditCodeTField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.link.ControllingDebitCreditCodeTLink
 * ControllingDebitCreditCodeTLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.ControllingDebitCreditCodeT#CONTROLLING_DEBIT_CREDIT_CODE
 * CONTROLLING_DEBIT_CREDIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.ControllingDebitCreditCodeT#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.ControllingDebitCreditCodeT#CONTROLLING_DEBIT_CREDIT_CODE_NAME
 * CONTROLLING_DEBIT_CREDIT_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitorcreditindicator.ControllingDebitCreditCodeT#TO_CONTROLLING_DEBIT_CREDIT_CODE
 * TO_CONTROLLING_DEBIT_CREDIT_CODE}</li>
 * </ul>
 *
 */
public interface ControllingDebitCreditCodeTSelectable extends EntitySelectable<ControllingDebitCreditCodeT>
{

}
