/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link DefectCategoryServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectCategoryService DefectCategoryService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultDefectCategoryServiceBatch
    extends
    BatchFluentHelperBasic<DefectCategoryServiceBatch, DefectCategoryServiceBatchChangeSet>
    implements
    DefectCategoryServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectCategoryService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultDefectCategoryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDefectCategoryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectCategoryService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectCategoryService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultDefectCategoryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDefectCategoryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectCategoryService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultDefectCategoryServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public DefectCategoryServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultDefectCategoryServiceBatchChangeSet(this, service);
    }

}
