/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link DefectCategoryServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectCategoryService DefectCategoryService}.
 *
 */
public class DefaultDefectCategoryServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<DefectCategoryServiceBatch, DefectCategoryServiceBatchChangeSet>
    implements
    DefectCategoryServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectCategoryService service;

    @SuppressWarnings( "deprecation" )
    DefaultDefectCategoryServiceBatchChangeSet(
        @Nonnull final DefaultDefectCategoryServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectCategoryService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultDefectCategoryServiceBatchChangeSet getThis()
    {
        return this;
    }

}
