/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.DefectCategory;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.DefectCategory DefectCategory}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.field.DefectCategoryField
 * DefectCategoryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.link.DefectCategoryLink
 * DefectCategoryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.DefectCategory#DEFECT_CATEGORY
 * DEFECT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.DefectCategory#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface DefectCategorySelectable extends EntitySelectable<DefectCategory>
{

}
