/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.DefectCategoryText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.DefectCategoryText DefectCategoryText}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.field.DefectCategoryTextField
 * DefectCategoryTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.link.DefectCategoryTextLink
 * DefectCategoryTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.DefectCategoryText#DEFECT_CATEGORY
 * DEFECT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.DefectCategoryText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.DefectCategoryText#DEFECT_CATEGORY_TEXT
 * DEFECT_CATEGORY_TEXT}</li>
 * </ul>
 *
 */
public interface DefectCategoryTextSelectable extends EntitySelectable<DefectCategoryText>
{

}
