/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.selectable.DefectClassSelectable;

/**
 * Fluent helper to fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClass
 * DefectClass} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class DefectClassByKeyFluentHelper
    extends
    FluentHelperByKey<DefectClassByKeyFluentHelper, DefectClass, DefectClassSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClass DefectClass} entity with the
     * provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code DefectClass}
     * @param servicePath
     *            Service path to be used to fetch a single {@code DefectClass}
     * @param defectClass
     *            Defect Class
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public DefectClassByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String defectClass )
    {
        super(servicePath, entityCollection);
        this.key.put("DefectClass", defectClass);
    }

    @Override
    @Nonnull
    protected Class<DefectClass> getEntityClass()
    {
        return DefectClass.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
