/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.field.DefectClassTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.link.DefectClassTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.selectable.DefectClassTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Defect Class Texts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DefectClassTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DefectClassText extends VdmEntity<DefectClassText>
{

    /**
     * Selector for all available fields of DefectClassText.
     *
     */
    public final static DefectClassTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DefectClass</b>
     * </p>
     *
     * @return Defect Class
     */
    @Key
    @SerializedName( "DefectClass" )
    @JsonProperty( "DefectClass" )
    @Nullable
    @ODataField( odataName = "DefectClass" )
    private String defectClass;
    /**
     * Use with available fluent helpers to apply the <b>DefectClass</b> field to query operations.
     *
     */
    public final static DefectClassTextField<String> DEFECT_CLASS = new DefectClassTextField<String>("DefectClass");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static DefectClassTextField<String> LANGUAGE = new DefectClassTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DefectClassText</b>
     * </p>
     *
     * @return Short Text
     */
    @SerializedName( "DefectClassText" )
    @JsonProperty( "DefectClassText" )
    @Nullable
    @ODataField( odataName = "DefectClassText" )
    private String defectClassText;
    /**
     * Use with available fluent helpers to apply the <b>DefectClassText</b> field to query operations.
     *
     */
    public final static DefectClassTextField<String> DEFECT_CLASS_TEXT =
        new DefectClassTextField<String>("DefectClassText");
    /**
     * Navigation property <b>to_DefectClass</b> for <b>DefectClassText</b> to single <b>DefectClass</b>.
     *
     */
    @SerializedName( "to_DefectClass" )
    @JsonProperty( "to_DefectClass" )
    @ODataField( odataName = "to_DefectClass" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DefectClass toDefectClass;
    /**
     * Use with available fluent helpers to apply the <b>to_DefectClass</b> navigation property to query operations.
     *
     */
    public final static DefectClassTextOneToOneLink<DefectClass> TO_DEFECT_CLASS =
        new DefectClassTextOneToOneLink<DefectClass>("to_DefectClass");

    @Nonnull
    @Override
    public Class<DefectClassText> getType()
    {
        return DefectClassText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DefectClass</b>
     * </p>
     *
     * @param defectClass
     *            Defect Class
     */
    public void setDefectClass( @Nullable final String defectClass )
    {
        rememberChangedField("DefectClass", this.defectClass);
        this.defectClass = defectClass;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DefectClassText</b>
     * </p>
     *
     * @param defectClassText
     *            Short Text
     */
    public void setDefectClassText( @Nullable final String defectClassText )
    {
        rememberChangedField("DefectClassText", this.defectClassText);
        this.defectClassText = defectClassText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DefectClassText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DefectClass", getDefectClass());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DefectClass", getDefectClass());
        values.put("Language", getLanguage());
        values.put("DefectClassText", getDefectClassText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DefectClass") ) {
                final Object value = values.remove("DefectClass");
                if( (value == null) || (!value.equals(getDefectClass())) ) {
                    setDefectClass(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("DefectClassText") ) {
                final Object value = values.remove("DefectClassText");
                if( (value == null) || (!value.equals(getDefectClassText())) ) {
                    setDefectClassText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_DefectClass") ) {
                final Object value = (values).remove("to_DefectClass");
                if( value instanceof Map ) {
                    if( toDefectClass == null ) {
                        toDefectClass = new DefectClass();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toDefectClass.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DefectClassTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DefectClassTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DefectClassTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DefectClassTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectClassService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toDefectClass != null ) {
            (values).put("to_DefectClass", toDefectClass);
        }
        return values;
    }

    /**
     * Fetches the <b>DefectClass</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_DefectClass</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>DefectClass</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DefectClass fetchDefectClass()
    {
        return fetchFieldAsSingle("to_DefectClass", DefectClass.class);
    }

    /**
     * Retrieval of associated <b>DefectClass</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_DefectClass</b>.
     * <p>
     * If the navigation property <b>to_DefectClass</b> of a queried <b>DefectClassText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DefectClass</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DefectClass getDefectClassOrFetch()
    {
        if( toDefectClass == null ) {
            toDefectClass = fetchDefectClass();
        }
        return toDefectClass;
    }

    /**
     * Retrieval of associated <b>DefectClass</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_DefectClass</b>.
     * <p>
     * If the navigation property for an entity <b>DefectClassText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_DefectClass</b> is already loaded, the result will
     *         contain the <b>DefectClass</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<DefectClass> getDefectClassIfPresent()
    {
        return Option.of(toDefectClass);
    }

    /**
     * Overwrites the associated <b>DefectClass</b> entity for the loaded navigation property <b>to_DefectClass</b>.
     *
     * @param value
     *            New <b>DefectClass</b> entity.
     */
    public void setDefectClass( final DefectClass value )
    {
        toDefectClass = value;
    }

    /**
     * Helper class to allow for fluent creation of DefectClassText instances.
     *
     */
    public final static class DefectClassTextBuilder
    {

        private DefectClass toDefectClass;
        private String defectClass = null;

        private DefectClassText.DefectClassTextBuilder toDefectClass( final DefectClass value )
        {
            toDefectClass = value;
            return this;
        }

        /**
         * Navigation property <b>to_DefectClass</b> for <b>DefectClassText</b> to single <b>DefectClass</b>.
         *
         * @param value
         *            The DefectClass to build this DefectClassText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DefectClassText.DefectClassTextBuilder defectClass( final DefectClass value )
        {
            return toDefectClass(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 2
         * <p>
         * Original property name from the Odata EDM: <b>DefectClass</b>
         * </p>
         *
         * @param value
         *            The defectClass to build this DefectClassText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DefectClassText.DefectClassTextBuilder defectClass( final String value )
        {
            defectClass = value;
            return this;
        }

    }

}
