/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.selectable.DefectClassTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClassText DefectClassText} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class DefectClassTextByKeyFluentHelper
    extends
    FluentHelperByKey<DefectClassTextByKeyFluentHelper, DefectClassText, DefectClassTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClassText DefectClassText} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code DefectClassText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code DefectClassText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param defectClass
     *            Defect Class
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public DefectClassTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String defectClass,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("DefectClass", defectClass);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<DefectClassText> getEntityClass()
    {
        return DefectClassText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
