/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link DefectClassServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectClassService DefectClassService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultDefectClassServiceBatch
    extends
    BatchFluentHelperBasic<DefectClassServiceBatch, DefectClassServiceBatchChangeSet>
    implements
    DefectClassServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectClassService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultDefectClassServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDefectClassServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectClassService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectClassService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultDefectClassServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDefectClassServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectClassService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultDefectClassServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public DefectClassServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultDefectClassServiceBatchChangeSet(this, service);
    }

}
