/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link DefectClassServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectClassService DefectClassService}.
 *
 */
public class DefaultDefectClassServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<DefectClassServiceBatch, DefectClassServiceBatchChangeSet>
    implements
    DefectClassServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectClassService service;

    @SuppressWarnings( "deprecation" )
    DefaultDefectClassServiceBatchChangeSet(
        @Nonnull final DefaultDefectClassServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectClassService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultDefectClassServiceBatchChangeSet getThis()
    {
        return this;
    }

}
