/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClass;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClass DefectClass}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.field.DefectClassField
 * DefectClassField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.link.DefectClassLink
 * DefectClassLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClass#DEFECT_CLASS
 * DEFECT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClass#INSPECTION_LOT_QUALITY_SCORE
 * INSPECTION_LOT_QUALITY_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClass#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface DefectClassSelectable extends EntitySelectable<DefectClass>
{

}
