/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClassText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClassText DefectClassText}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.field.DefectClassTextField
 * DefectClassTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.link.DefectClassTextLink DefectClassTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClassText#DEFECT_CLASS
 * DEFECT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClassText#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClassText#DEFECT_CLASS_TEXT
 * DEFECT_CLASS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClassText#TO_DEFECT_CLASS
 * TO_DEFECT_CLASS}</li>
 * </ul>
 *
 */
public interface DefectClassTextSelectable extends EntitySelectable<DefectClassText>
{

}
