/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.field.DefectCodeGroupField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.link.DefectCodeGroupLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.selectable.DefectCodeGroupSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Defect Code Groups
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DefectCodeGroupType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DefectCodeGroup extends VdmEntity<DefectCodeGroup>
{

    /**
     * Selector for all available fields of DefectCodeGroup.
     *
     */
    public final static DefectCodeGroupSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>DefectCodeGroup</b>
     * </p>
     *
     * @return Defect Code Group
     */
    @Key
    @SerializedName( "DefectCodeGroup" )
    @JsonProperty( "DefectCodeGroup" )
    @Nullable
    @ODataField( odataName = "DefectCodeGroup" )
    private String defectCodeGroup;
    /**
     * Use with available fluent helpers to apply the <b>DefectCodeGroup</b> field to query operations.
     *
     */
    public final static DefectCodeGroupField<String> DEFECT_CODE_GROUP =
        new DefectCodeGroupField<String>("DefectCodeGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CodeGroupIsInactive</b>
     * </p>
     *
     * @return Status of Code Group or Code Record
     */
    @SerializedName( "CodeGroupIsInactive" )
    @JsonProperty( "CodeGroupIsInactive" )
    @Nullable
    @ODataField( odataName = "CodeGroupIsInactive" )
    private String codeGroupIsInactive;
    /**
     * Use with available fluent helpers to apply the <b>CodeGroupIsInactive</b> field to query operations.
     *
     */
    public final static DefectCodeGroupField<String> CODE_GROUP_IS_INACTIVE =
        new DefectCodeGroupField<String>("CodeGroupIsInactive");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CodeGroupIsUsable</b>
     * </p>
     *
     * @return Code Group Is Usable
     */
    @SerializedName( "CodeGroupIsUsable" )
    @JsonProperty( "CodeGroupIsUsable" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CodeGroupIsUsable" )
    private Boolean codeGroupIsUsable;
    /**
     * Use with available fluent helpers to apply the <b>CodeGroupIsUsable</b> field to query operations.
     *
     */
    public final static DefectCodeGroupField<Boolean> CODE_GROUP_IS_USABLE =
        new DefectCodeGroupField<Boolean>("CodeGroupIsUsable");
    /**
     * Navigation property <b>to_Text</b> for <b>DefectCodeGroup</b> to multiple <b>DefectCodeGroupText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DefectCodeGroupText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static DefectCodeGroupLink<DefectCodeGroupText> TO_TEXT =
        new DefectCodeGroupLink<DefectCodeGroupText>("to_Text");

    @Nonnull
    @Override
    public Class<DefectCodeGroup> getType()
    {
        return DefectCodeGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>DefectCodeGroup</b>
     * </p>
     *
     * @param defectCodeGroup
     *            Defect Code Group
     */
    public void setDefectCodeGroup( @Nullable final String defectCodeGroup )
    {
        rememberChangedField("DefectCodeGroup", this.defectCodeGroup);
        this.defectCodeGroup = defectCodeGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CodeGroupIsInactive</b>
     * </p>
     *
     * @param codeGroupIsInactive
     *            Status of Code Group or Code Record
     */
    public void setCodeGroupIsInactive( @Nullable final String codeGroupIsInactive )
    {
        rememberChangedField("CodeGroupIsInactive", this.codeGroupIsInactive);
        this.codeGroupIsInactive = codeGroupIsInactive;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CodeGroupIsUsable</b>
     * </p>
     *
     * @param codeGroupIsUsable
     *            Code Group Is Usable
     */
    public void setCodeGroupIsUsable( @Nullable final Boolean codeGroupIsUsable )
    {
        rememberChangedField("CodeGroupIsUsable", this.codeGroupIsUsable);
        this.codeGroupIsUsable = codeGroupIsUsable;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DefectCodeGroup";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DefectCodeGroup", getDefectCodeGroup());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DefectCodeGroup", getDefectCodeGroup());
        values.put("CodeGroupIsInactive", getCodeGroupIsInactive());
        values.put("CodeGroupIsUsable", getCodeGroupIsUsable());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DefectCodeGroup") ) {
                final Object value = values.remove("DefectCodeGroup");
                if( (value == null) || (!value.equals(getDefectCodeGroup())) ) {
                    setDefectCodeGroup(((String) value));
                }
            }
            if( values.containsKey("CodeGroupIsInactive") ) {
                final Object value = values.remove("CodeGroupIsInactive");
                if( (value == null) || (!value.equals(getCodeGroupIsInactive())) ) {
                    setCodeGroupIsInactive(((String) value));
                }
            }
            if( values.containsKey("CodeGroupIsUsable") ) {
                final Object value = values.remove("CodeGroupIsUsable");
                if( (value == null) || (!value.equals(getCodeGroupIsUsable())) ) {
                    setCodeGroupIsUsable(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DefectCodeGroupText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new DefectCodeGroupText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DefectCodeGroupField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DefectCodeGroupField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DefectCodeGroupField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DefectCodeGroupField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectCodeAndCodeGroupService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>DefectCodeGroupText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DefectCodeGroupText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DefectCodeGroupText> fetchText()
    {
        return fetchFieldAsList("to_Text", DefectCodeGroupText.class);
    }

    /**
     * Retrieval of associated <b>DefectCodeGroupText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>DefectCodeGroup</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DefectCodeGroupText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DefectCodeGroupText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>DefectCodeGroupText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>DefectCodeGroup</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>DefectCodeGroupText</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<DefectCodeGroupText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>DefectCodeGroupText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>DefectCodeGroup</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DefectCodeGroupText</b> entities.
     */
    public void setText( @Nonnull final List<DefectCodeGroupText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DefectCodeGroupText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>DefectCodeGroup</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DefectCodeGroupText</b> entities.
     */
    public void addText( DefectCodeGroupText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of DefectCodeGroup instances.
     *
     */
    public final static class DefectCodeGroupBuilder
    {

        private List<DefectCodeGroupText> toText = Lists.newArrayList();

        private DefectCodeGroup.DefectCodeGroupBuilder toText( final List<DefectCodeGroupText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>DefectCodeGroup</b> to multiple <b>DefectCodeGroupText</b>.
         *
         * @param value
         *            The DefectCodeGroupTexts to build this DefectCodeGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DefectCodeGroup.DefectCodeGroupBuilder text( DefectCodeGroupText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
