/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.field.DefectCodeTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.selectable.DefectCodeTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Defect Code Texts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DefectCodeTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DefectCodeText extends VdmEntity<DefectCodeText>
{

    /**
     * Selector for all available fields of DefectCodeText.
     *
     */
    public final static DefectCodeTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>DefectCodeGroup</b>
     * </p>
     *
     * @return Defect Code Group
     */
    @Key
    @SerializedName( "DefectCodeGroup" )
    @JsonProperty( "DefectCodeGroup" )
    @Nullable
    @ODataField( odataName = "DefectCodeGroup" )
    private String defectCodeGroup;
    /**
     * Use with available fluent helpers to apply the <b>DefectCodeGroup</b> field to query operations.
     *
     */
    public final static DefectCodeTextField<String> DEFECT_CODE_GROUP =
        new DefectCodeTextField<String>("DefectCodeGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DefectCode</b>
     * </p>
     *
     * @return Defect Code
     */
    @Key
    @SerializedName( "DefectCode" )
    @JsonProperty( "DefectCode" )
    @Nullable
    @ODataField( odataName = "DefectCode" )
    private String defectCode;
    /**
     * Use with available fluent helpers to apply the <b>DefectCode</b> field to query operations.
     *
     */
    public final static DefectCodeTextField<String> DEFECT_CODE = new DefectCodeTextField<String>("DefectCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static DefectCodeTextField<String> LANGUAGE = new DefectCodeTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DefectCodeText</b>
     * </p>
     *
     * @return Text for Defect Code
     */
    @SerializedName( "DefectCodeText" )
    @JsonProperty( "DefectCodeText" )
    @Nullable
    @ODataField( odataName = "DefectCodeText" )
    private String defectCodeText;
    /**
     * Use with available fluent helpers to apply the <b>DefectCodeText</b> field to query operations.
     *
     */
    public final static DefectCodeTextField<String> DEFECT_CODE_TEXT =
        new DefectCodeTextField<String>("DefectCodeText");

    @Nonnull
    @Override
    public Class<DefectCodeText> getType()
    {
        return DefectCodeText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>DefectCodeGroup</b>
     * </p>
     *
     * @param defectCodeGroup
     *            Defect Code Group
     */
    public void setDefectCodeGroup( @Nullable final String defectCodeGroup )
    {
        rememberChangedField("DefectCodeGroup", this.defectCodeGroup);
        this.defectCodeGroup = defectCodeGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DefectCode</b>
     * </p>
     *
     * @param defectCode
     *            Defect Code
     */
    public void setDefectCode( @Nullable final String defectCode )
    {
        rememberChangedField("DefectCode", this.defectCode);
        this.defectCode = defectCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DefectCodeText</b>
     * </p>
     *
     * @param defectCodeText
     *            Text for Defect Code
     */
    public void setDefectCodeText( @Nullable final String defectCodeText )
    {
        rememberChangedField("DefectCodeText", this.defectCodeText);
        this.defectCodeText = defectCodeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DefectCodeText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DefectCodeGroup", getDefectCodeGroup());
        result.put("DefectCode", getDefectCode());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DefectCodeGroup", getDefectCodeGroup());
        values.put("DefectCode", getDefectCode());
        values.put("Language", getLanguage());
        values.put("DefectCodeText", getDefectCodeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DefectCodeGroup") ) {
                final Object value = values.remove("DefectCodeGroup");
                if( (value == null) || (!value.equals(getDefectCodeGroup())) ) {
                    setDefectCodeGroup(((String) value));
                }
            }
            if( values.containsKey("DefectCode") ) {
                final Object value = values.remove("DefectCode");
                if( (value == null) || (!value.equals(getDefectCode())) ) {
                    setDefectCode(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("DefectCodeText") ) {
                final Object value = values.remove("DefectCodeText");
                if( (value == null) || (!value.equals(getDefectCodeText())) ) {
                    setDefectCodeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> DefectCodeTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DefectCodeTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DefectCodeTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DefectCodeTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectCodeAndCodeGroupService.DEFAULT_SERVICE_PATH);
    }

}
