/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link DefectCodeAndCodeGroupServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectCodeAndCodeGroupService
 * DefectCodeAndCodeGroupService}.
 *
 */
public class DefaultDefectCodeAndCodeGroupServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<DefectCodeAndCodeGroupServiceBatch, DefectCodeAndCodeGroupServiceBatchChangeSet>
    implements
    DefectCodeAndCodeGroupServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectCodeAndCodeGroupService service;

    @SuppressWarnings( "deprecation" )
    DefaultDefectCodeAndCodeGroupServiceBatchChangeSet(
        @Nonnull final DefaultDefectCodeAndCodeGroupServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectCodeAndCodeGroupService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultDefectCodeAndCodeGroupServiceBatchChangeSet getThis()
    {
        return this;
    }

}
