/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupText
 * DefectCodeGroupText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.field.DefectCodeGroupTextField
 * DefectCodeGroupTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.link.DefectCodeGroupTextLink
 * DefectCodeGroupTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupText#DEFECT_CODE_GROUP
 * DEFECT_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupText#DEFECT_CODE_GROUP_TEXT
 * DEFECT_CODE_GROUP_TEXT}</li>
 * </ul>
 *
 */
public interface DefectCodeGroupTextSelectable extends EntitySelectable<DefectCodeGroupText>
{

}
