/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCode;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCode DefectCode}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.field.DefectCodeField
 * DefectCodeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.link.DefectCodeLink
 * DefectCodeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCode#DEFECT_CODE_GROUP
 * DEFECT_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCode#DEFECT_CODE
 * DEFECT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCode#CODE_IS_INACTIVE
 * CODE_IS_INACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCode#CODE_GROUP_IS_USABLE
 * CODE_GROUP_IS_USABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCode#TO_DEFECT_CODE_GROUP
 * TO_DEFECT_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCode#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface DefectCodeSelectable extends EntitySelectable<DefectCode>
{

}
