/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeText DefectCodeText}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.field.DefectCodeTextField
 * DefectCodeTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.link.DefectCodeTextLink
 * DefectCodeTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeText#DEFECT_CODE_GROUP
 * DEFECT_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeText#DEFECT_CODE
 * DEFECT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeText#DEFECT_CODE_TEXT
 * DEFECT_CODE_TEXT}</li>
 * </ul>
 *
 */
public interface DefectCodeTextSelectable extends EntitySelectable<DefectCodeText>
{

}
