/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.field.DefectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.selectable.DefectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Defects
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DefectType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Defect extends VdmEntity<Defect>
{

    /**
     * Selector for all available fields of Defect.
     *
     */
    public final static DefectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>DefectInternalID</b>
     * </p>
     *
     * @return Notification Number
     */
    @Key
    @SerializedName( "DefectInternalID" )
    @JsonProperty( "DefectInternalID" )
    @Nullable
    @ODataField( odataName = "DefectInternalID" )
    private String defectInternalID;
    /**
     * Use with available fluent helpers to apply the <b>DefectInternalID</b> field to query operations.
     *
     */
    public final static DefectField<String> DEFECT_INTERNAL_ID = new DefectField<String>("DefectInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>Defect</b>
     * </p>
     *
     * @return Defect Number
     */
    @SerializedName( "Defect" )
    @JsonProperty( "Defect" )
    @Nullable
    @ODataField( odataName = "Defect" )
    private String defect;
    /**
     * Use with available fluent helpers to apply the <b>Defect</b> field to query operations.
     *
     */
    public final static DefectField<String> DEFECT = new DefectField<String>("Defect");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DefectCategory</b>
     * </p>
     *
     * @return Defect Category
     */
    @SerializedName( "DefectCategory" )
    @JsonProperty( "DefectCategory" )
    @Nullable
    @ODataField( odataName = "DefectCategory" )
    private String defectCategory;
    /**
     * Use with available fluent helpers to apply the <b>DefectCategory</b> field to query operations.
     *
     */
    public final static DefectField<String> DEFECT_CATEGORY = new DefectField<String>("DefectCategory");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static DefectField<String> CREATED_BY_USER = new DefectField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static DefectField<LocalDateTime> CREATION_DATE = new DefectField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static DefectField<String> LAST_CHANGED_BY_USER = new DefectField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static DefectField<LocalDateTime> LAST_CHANGE_DATE = new DefectField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DefectText</b>
     * </p>
     *
     * @return Defect Text
     */
    @SerializedName( "DefectText" )
    @JsonProperty( "DefectText" )
    @Nullable
    @ODataField( odataName = "DefectText" )
    private String defectText;
    /**
     * Use with available fluent helpers to apply the <b>DefectText</b> field to query operations.
     *
     */
    public final static DefectField<String> DEFECT_TEXT = new DefectField<String>("DefectText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DefectCodeCatalog</b>
     * </p>
     *
     * @return Catalog Type - Problems/Defects
     */
    @SerializedName( "DefectCodeCatalog" )
    @JsonProperty( "DefectCodeCatalog" )
    @Nullable
    @ODataField( odataName = "DefectCodeCatalog" )
    private String defectCodeCatalog;
    /**
     * Use with available fluent helpers to apply the <b>DefectCodeCatalog</b> field to query operations.
     *
     */
    public final static DefectField<String> DEFECT_CODE_CATALOG = new DefectField<String>("DefectCodeCatalog");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>DefectCodeGroup</b>
     * </p>
     *
     * @return Defect Code Group
     */
    @SerializedName( "DefectCodeGroup" )
    @JsonProperty( "DefectCodeGroup" )
    @Nullable
    @ODataField( odataName = "DefectCodeGroup" )
    private String defectCodeGroup;
    /**
     * Use with available fluent helpers to apply the <b>DefectCodeGroup</b> field to query operations.
     *
     */
    public final static DefectField<String> DEFECT_CODE_GROUP = new DefectField<String>("DefectCodeGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DefectCode</b>
     * </p>
     *
     * @return Defect Code
     */
    @SerializedName( "DefectCode" )
    @JsonProperty( "DefectCode" )
    @Nullable
    @ODataField( odataName = "DefectCode" )
    private String defectCode;
    /**
     * Use with available fluent helpers to apply the <b>DefectCode</b> field to query operations.
     *
     */
    public final static DefectField<String> DEFECT_CODE = new DefectField<String>("DefectCode");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DefectCodeVersion</b>
     * </p>
     *
     * @return Version Number
     */
    @SerializedName( "DefectCodeVersion" )
    @JsonProperty( "DefectCodeVersion" )
    @Nullable
    @ODataField( odataName = "DefectCodeVersion" )
    private String defectCodeVersion;
    /**
     * Use with available fluent helpers to apply the <b>DefectCodeVersion</b> field to query operations.
     *
     */
    public final static DefectField<String> DEFECT_CODE_VERSION = new DefectField<String>("DefectCodeVersion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DefectObjectCodeCatalog</b>
     * </p>
     *
     * @return Defect Location Catalog
     */
    @SerializedName( "DefectObjectCodeCatalog" )
    @JsonProperty( "DefectObjectCodeCatalog" )
    @Nullable
    @ODataField( odataName = "DefectObjectCodeCatalog" )
    private String defectObjectCodeCatalog;
    /**
     * Use with available fluent helpers to apply the <b>DefectObjectCodeCatalog</b> field to query operations.
     *
     */
    public final static DefectField<String> DEFECT_OBJECT_CODE_CATALOG =
        new DefectField<String>("DefectObjectCodeCatalog");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>DefectObjectCodeGroup</b>
     * </p>
     *
     * @return Defect Location Code Group
     */
    @SerializedName( "DefectObjectCodeGroup" )
    @JsonProperty( "DefectObjectCodeGroup" )
    @Nullable
    @ODataField( odataName = "DefectObjectCodeGroup" )
    private String defectObjectCodeGroup;
    /**
     * Use with available fluent helpers to apply the <b>DefectObjectCodeGroup</b> field to query operations.
     *
     */
    public final static DefectField<String> DEFECT_OBJECT_CODE_GROUP = new DefectField<String>("DefectObjectCodeGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DefectObjectCode</b>
     * </p>
     *
     * @return Defect Location Code
     */
    @SerializedName( "DefectObjectCode" )
    @JsonProperty( "DefectObjectCode" )
    @Nullable
    @ODataField( odataName = "DefectObjectCode" )
    private String defectObjectCode;
    /**
     * Use with available fluent helpers to apply the <b>DefectObjectCode</b> field to query operations.
     *
     */
    public final static DefectField<String> DEFECT_OBJECT_CODE = new DefectField<String>("DefectObjectCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DefectiveQuantity</b>
     * </p>
     *
     * @return Defective Quantity for Item (Internal)
     */
    @SerializedName( "DefectiveQuantity" )
    @JsonProperty( "DefectiveQuantity" )
    @Nullable
    @ODataField( odataName = "DefectiveQuantity" )
    private BigDecimal defectiveQuantity;
    /**
     * Use with available fluent helpers to apply the <b>DefectiveQuantity</b> field to query operations.
     *
     */
    public final static DefectField<BigDecimal> DEFECTIVE_QUANTITY = new DefectField<BigDecimal>("DefectiveQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DefectiveQuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure for Item
     */
    @SerializedName( "DefectiveQuantityUnit" )
    @JsonProperty( "DefectiveQuantityUnit" )
    @Nullable
    @ODataField( odataName = "DefectiveQuantityUnit" )
    private String defectiveQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>DefectiveQuantityUnit</b> field to query operations.
     *
     */
    public final static DefectField<String> DEFECTIVE_QUANTITY_UNIT = new DefectField<String>("DefectiveQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Order Number (Production Order)
     */
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static DefectField<String> MANUFACTURING_ORDER = new DefectField<String>("ManufacturingOrder");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalID</b>
     * </p>
     *
     * @return Plan Number for Operations in Order (Production Order)
     */
    @SerializedName( "OrderInternalID" )
    @JsonProperty( "OrderInternalID" )
    @Nullable
    @ODataField( odataName = "OrderInternalID" )
    private String orderInternalID;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalID</b> field to query operations.
     *
     */
    public final static DefectField<String> ORDER_INTERNAL_ID = new DefectField<String>("OrderInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @return Operation or Phase Number
     */
    @SerializedName( "ManufacturingOrderOperation" )
    @JsonProperty( "ManufacturingOrderOperation" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderOperation" )
    private String manufacturingOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderOperation</b> field to query operations.
     *
     */
    public final static DefectField<String> MANUFACTURING_ORDER_OPERATION =
        new DefectField<String>("ManufacturingOrderOperation");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     * </p>
     *
     * @return Sequence
     */
    @SerializedName( "ManufacturingOrderSequence" )
    @JsonProperty( "ManufacturingOrderSequence" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderSequence" )
    private String manufacturingOrderSequence;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderSequence</b> field to query operations.
     *
     */
    public final static DefectField<String> MANUFACTURING_ORDER_SEQUENCE =
        new DefectField<String>("ManufacturingOrderSequence");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return System Time of Creation
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static DefectField<LocalTime> CREATION_TIME = new DefectField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @return System Time of Change
     */
    @SerializedName( "LastChangeTime" )
    @JsonProperty( "LastChangeTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime lastChangeTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeTime</b> field to query operations.
     *
     */
    public final static DefectField<LocalTime> LAST_CHANGE_TIME = new DefectField<LocalTime>("LastChangeTime");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DefectClass</b>
     * </p>
     *
     * @return Defect Class
     */
    @SerializedName( "DefectClass" )
    @JsonProperty( "DefectClass" )
    @Nullable
    @ODataField( odataName = "DefectClass" )
    private String defectClass;
    /**
     * Use with available fluent helpers to apply the <b>DefectClass</b> field to query operations.
     *
     */
    public final static DefectField<String> DEFECT_CLASS = new DefectField<String>("DefectClass");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfDefects</b>
     * </p>
     *
     * @return Number of Defect Occurrences
     */
    @SerializedName( "NumberOfDefects" )
    @JsonProperty( "NumberOfDefects" )
    @Nullable
    @ODataField( odataName = "NumberOfDefects" )
    private Integer numberOfDefects;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfDefects</b> field to query operations.
     *
     */
    public final static DefectField<Integer> NUMBER_OF_DEFECTS = new DefectField<Integer>("NumberOfDefects");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     * </p>
     *
     * @return Current Node Number from Order Counter
     */
    @SerializedName( "InspPlanOperationInternalID" )
    @JsonProperty( "InspPlanOperationInternalID" )
    @Nullable
    @ODataField( odataName = "InspPlanOperationInternalID" )
    private String inspPlanOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>InspPlanOperationInternalID</b> field to query operations.
     *
     */
    public final static DefectField<String> INSP_PLAN_OPERATION_INTERNAL_ID =
        new DefectField<String>("InspPlanOperationInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionCharacteristic</b>
     * </p>
     *
     * @return Inspection Characteristic Number
     */
    @SerializedName( "InspectionCharacteristic" )
    @JsonProperty( "InspectionCharacteristic" )
    @Nullable
    @ODataField( odataName = "InspectionCharacteristic" )
    private String inspectionCharacteristic;
    /**
     * Use with available fluent helpers to apply the <b>InspectionCharacteristic</b> field to query operations.
     *
     */
    public final static DefectField<String> INSPECTION_CHARACTERISTIC =
        new DefectField<String>("InspectionCharacteristic");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetInternalID</b>
     * </p>
     *
     * @return Inspection Sample Number
     */
    @SerializedName( "InspectionSubsetInternalID" )
    @JsonProperty( "InspectionSubsetInternalID" )
    @Nullable
    @ODataField( odataName = "InspectionSubsetInternalID" )
    private String inspectionSubsetInternalID;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubsetInternalID</b> field to query operations.
     *
     */
    public final static DefectField<String> INSPECTION_SUBSET_INTERNAL_ID =
        new DefectField<String>("InspectionSubsetInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaterialSample</b>
     * </p>
     *
     * @return Material Sample Number
     */
    @SerializedName( "MaterialSample" )
    @JsonProperty( "MaterialSample" )
    @Nullable
    @ODataField( odataName = "MaterialSample" )
    private String materialSample;
    /**
     * Use with available fluent helpers to apply the <b>MaterialSample</b> field to query operations.
     *
     */
    public final static DefectField<String> MATERIAL_SAMPLE = new DefectField<String>("MaterialSample");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static DefectField<String> WORK_CENTER_TYPE_CODE = new DefectField<String>("WorkCenterTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of the Work Center
     */
    @SerializedName( "MainWorkCenterInternalID" )
    @JsonProperty( "MainWorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "MainWorkCenterInternalID" )
    private String mainWorkCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenterInternalID</b> field to query operations.
     *
     */
    public final static DefectField<String> MAIN_WORK_CENTER_INTERNAL_ID =
        new DefectField<String>("MainWorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterPlant</b>
     * </p>
     *
     * @return Plant for Work Center
     */
    @SerializedName( "MainWorkCenterPlant" )
    @JsonProperty( "MainWorkCenterPlant" )
    @Nullable
    @ODataField( odataName = "MainWorkCenterPlant" )
    private String mainWorkCenterPlant;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenterPlant</b> field to query operations.
     *
     */
    public final static DefectField<String> MAIN_WORK_CENTER_PLANT = new DefectField<String>("MainWorkCenterPlant");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "MainWorkCenter" )
    @JsonProperty( "MainWorkCenter" )
    @Nullable
    @ODataField( odataName = "MainWorkCenter" )
    private String mainWorkCenter;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenter</b> field to query operations.
     *
     */
    public final static DefectField<String> MAIN_WORK_CENTER = new DefectField<String>("MainWorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static DefectField<String> EQUIPMENT = new DefectField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Functional Location
     */
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static DefectField<String> FUNCTIONAL_LOCATION = new DefectField<String>("FunctionalLocation");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Is Deleted
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @ODataField( odataName = "IsDeleted" )
    private String isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static DefectField<String> IS_DELETED = new DefectField<String>("IsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DefectOrigin</b>
     * </p>
     *
     * @return Origin of Item Record
     */
    @SerializedName( "DefectOrigin" )
    @JsonProperty( "DefectOrigin" )
    @Nullable
    @ODataField( odataName = "DefectOrigin" )
    private String defectOrigin;
    /**
     * Use with available fluent helpers to apply the <b>DefectOrigin</b> field to query operations.
     *
     */
    public final static DefectField<String> DEFECT_ORIGIN = new DefectField<String>("DefectOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Defective Material
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static DefectField<String> MATERIAL = new DefectField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static DefectField<String> PLANT = new DefectField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @return Inspection Lot Number
     */
    @SerializedName( "InspectionLot" )
    @JsonProperty( "InspectionLot" )
    @Nullable
    @ODataField( odataName = "InspectionLot" )
    private String inspectionLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLot</b> field to query operations.
     *
     */
    public final static DefectField<String> INSPECTION_LOT = new DefectField<String>("InspectionLot");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>CatalogProfile</b>
     * </p>
     *
     * @return Catalog Profile
     */
    @SerializedName( "CatalogProfile" )
    @JsonProperty( "CatalogProfile" )
    @Nullable
    @ODataField( odataName = "CatalogProfile" )
    private String catalogProfile;
    /**
     * Use with available fluent helpers to apply the <b>CatalogProfile</b> field to query operations.
     *
     */
    public final static DefectField<String> CATALOG_PROFILE = new DefectField<String>("CatalogProfile");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static DefectField<ZonedDateTime> CHANGED_DATE_TIME =
        new DefectField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<Defect> getType()
    {
        return Defect.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>DefectInternalID</b>
     * </p>
     *
     * @param defectInternalID
     *            Notification Number
     */
    public void setDefectInternalID( @Nullable final String defectInternalID )
    {
        rememberChangedField("DefectInternalID", this.defectInternalID);
        this.defectInternalID = defectInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>Defect</b>
     * </p>
     *
     * @param defect
     *            Defect Number
     */
    public void setDefect( @Nullable final String defect )
    {
        rememberChangedField("Defect", this.defect);
        this.defect = defect;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DefectCategory</b>
     * </p>
     *
     * @param defectCategory
     *            Defect Category
     */
    public void setDefectCategory( @Nullable final String defectCategory )
    {
        rememberChangedField("DefectCategory", this.defectCategory);
        this.defectCategory = defectCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DefectText</b>
     * </p>
     *
     * @param defectText
     *            Defect Text
     */
    public void setDefectText( @Nullable final String defectText )
    {
        rememberChangedField("DefectText", this.defectText);
        this.defectText = defectText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DefectCodeCatalog</b>
     * </p>
     *
     * @param defectCodeCatalog
     *            Catalog Type - Problems/Defects
     */
    public void setDefectCodeCatalog( @Nullable final String defectCodeCatalog )
    {
        rememberChangedField("DefectCodeCatalog", this.defectCodeCatalog);
        this.defectCodeCatalog = defectCodeCatalog;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>DefectCodeGroup</b>
     * </p>
     *
     * @param defectCodeGroup
     *            Defect Code Group
     */
    public void setDefectCodeGroup( @Nullable final String defectCodeGroup )
    {
        rememberChangedField("DefectCodeGroup", this.defectCodeGroup);
        this.defectCodeGroup = defectCodeGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DefectCode</b>
     * </p>
     *
     * @param defectCode
     *            Defect Code
     */
    public void setDefectCode( @Nullable final String defectCode )
    {
        rememberChangedField("DefectCode", this.defectCode);
        this.defectCode = defectCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DefectCodeVersion</b>
     * </p>
     *
     * @param defectCodeVersion
     *            Version Number
     */
    public void setDefectCodeVersion( @Nullable final String defectCodeVersion )
    {
        rememberChangedField("DefectCodeVersion", this.defectCodeVersion);
        this.defectCodeVersion = defectCodeVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DefectObjectCodeCatalog</b>
     * </p>
     *
     * @param defectObjectCodeCatalog
     *            Defect Location Catalog
     */
    public void setDefectObjectCodeCatalog( @Nullable final String defectObjectCodeCatalog )
    {
        rememberChangedField("DefectObjectCodeCatalog", this.defectObjectCodeCatalog);
        this.defectObjectCodeCatalog = defectObjectCodeCatalog;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>DefectObjectCodeGroup</b>
     * </p>
     *
     * @param defectObjectCodeGroup
     *            Defect Location Code Group
     */
    public void setDefectObjectCodeGroup( @Nullable final String defectObjectCodeGroup )
    {
        rememberChangedField("DefectObjectCodeGroup", this.defectObjectCodeGroup);
        this.defectObjectCodeGroup = defectObjectCodeGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DefectObjectCode</b>
     * </p>
     *
     * @param defectObjectCode
     *            Defect Location Code
     */
    public void setDefectObjectCode( @Nullable final String defectObjectCode )
    {
        rememberChangedField("DefectObjectCode", this.defectObjectCode);
        this.defectObjectCode = defectObjectCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DefectiveQuantity</b>
     * </p>
     *
     * @param defectiveQuantity
     *            Defective Quantity for Item (Internal)
     */
    public void setDefectiveQuantity( @Nullable final BigDecimal defectiveQuantity )
    {
        rememberChangedField("DefectiveQuantity", this.defectiveQuantity);
        this.defectiveQuantity = defectiveQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DefectiveQuantityUnit</b>
     * </p>
     *
     * @param defectiveQuantityUnit
     *            Unit of Measure for Item
     */
    public void setDefectiveQuantityUnit( @Nullable final String defectiveQuantityUnit )
    {
        rememberChangedField("DefectiveQuantityUnit", this.defectiveQuantityUnit);
        this.defectiveQuantityUnit = defectiveQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Order Number (Production Order)
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalID</b>
     * </p>
     *
     * @param orderInternalID
     *            Plan Number for Operations in Order (Production Order)
     */
    public void setOrderInternalID( @Nullable final String orderInternalID )
    {
        rememberChangedField("OrderInternalID", this.orderInternalID);
        this.orderInternalID = orderInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @param manufacturingOrderOperation
     *            Operation or Phase Number
     */
    public void setManufacturingOrderOperation( @Nullable final String manufacturingOrderOperation )
    {
        rememberChangedField("ManufacturingOrderOperation", this.manufacturingOrderOperation);
        this.manufacturingOrderOperation = manufacturingOrderOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     * </p>
     *
     * @param manufacturingOrderSequence
     *            Sequence
     */
    public void setManufacturingOrderSequence( @Nullable final String manufacturingOrderSequence )
    {
        rememberChangedField("ManufacturingOrderSequence", this.manufacturingOrderSequence);
        this.manufacturingOrderSequence = manufacturingOrderSequence;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            System Time of Creation
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @param lastChangeTime
     *            System Time of Change
     */
    public void setLastChangeTime( @Nullable final LocalTime lastChangeTime )
    {
        rememberChangedField("LastChangeTime", this.lastChangeTime);
        this.lastChangeTime = lastChangeTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DefectClass</b>
     * </p>
     *
     * @param defectClass
     *            Defect Class
     */
    public void setDefectClass( @Nullable final String defectClass )
    {
        rememberChangedField("DefectClass", this.defectClass);
        this.defectClass = defectClass;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfDefects</b>
     * </p>
     *
     * @param numberOfDefects
     *            Number of Defect Occurrences
     */
    public void setNumberOfDefects( @Nullable final Integer numberOfDefects )
    {
        rememberChangedField("NumberOfDefects", this.numberOfDefects);
        this.numberOfDefects = numberOfDefects;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     * </p>
     *
     * @param inspPlanOperationInternalID
     *            Current Node Number from Order Counter
     */
    public void setInspPlanOperationInternalID( @Nullable final String inspPlanOperationInternalID )
    {
        rememberChangedField("InspPlanOperationInternalID", this.inspPlanOperationInternalID);
        this.inspPlanOperationInternalID = inspPlanOperationInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionCharacteristic</b>
     * </p>
     *
     * @param inspectionCharacteristic
     *            Inspection Characteristic Number
     */
    public void setInspectionCharacteristic( @Nullable final String inspectionCharacteristic )
    {
        rememberChangedField("InspectionCharacteristic", this.inspectionCharacteristic);
        this.inspectionCharacteristic = inspectionCharacteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetInternalID</b>
     * </p>
     *
     * @param inspectionSubsetInternalID
     *            Inspection Sample Number
     */
    public void setInspectionSubsetInternalID( @Nullable final String inspectionSubsetInternalID )
    {
        rememberChangedField("InspectionSubsetInternalID", this.inspectionSubsetInternalID);
        this.inspectionSubsetInternalID = inspectionSubsetInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaterialSample</b>
     * </p>
     *
     * @param materialSample
     *            Material Sample Number
     */
    public void setMaterialSample( @Nullable final String materialSample )
    {
        rememberChangedField("MaterialSample", this.materialSample);
        this.materialSample = materialSample;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterInternalID</b>
     * </p>
     *
     * @param mainWorkCenterInternalID
     *            Object ID of the Work Center
     */
    public void setMainWorkCenterInternalID( @Nullable final String mainWorkCenterInternalID )
    {
        rememberChangedField("MainWorkCenterInternalID", this.mainWorkCenterInternalID);
        this.mainWorkCenterInternalID = mainWorkCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterPlant</b>
     * </p>
     *
     * @param mainWorkCenterPlant
     *            Plant for Work Center
     */
    public void setMainWorkCenterPlant( @Nullable final String mainWorkCenterPlant )
    {
        rememberChangedField("MainWorkCenterPlant", this.mainWorkCenterPlant);
        this.mainWorkCenterPlant = mainWorkCenterPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenter</b>
     * </p>
     *
     * @param mainWorkCenter
     *            Work Center
     */
    public void setMainWorkCenter( @Nullable final String mainWorkCenter )
    {
        rememberChangedField("MainWorkCenter", this.mainWorkCenter);
        this.mainWorkCenter = mainWorkCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Functional Location
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Is Deleted
     */
    public void setIsDeleted( @Nullable final String isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DefectOrigin</b>
     * </p>
     *
     * @param defectOrigin
     *            Origin of Item Record
     */
    public void setDefectOrigin( @Nullable final String defectOrigin )
    {
        rememberChangedField("DefectOrigin", this.defectOrigin);
        this.defectOrigin = defectOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Defective Material
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @param inspectionLot
     *            Inspection Lot Number
     */
    public void setInspectionLot( @Nullable final String inspectionLot )
    {
        rememberChangedField("InspectionLot", this.inspectionLot);
        this.inspectionLot = inspectionLot;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>CatalogProfile</b>
     * </p>
     *
     * @param catalogProfile
     *            Catalog Profile
     */
    public void setCatalogProfile( @Nullable final String catalogProfile )
    {
        rememberChangedField("CatalogProfile", this.catalogProfile);
        this.catalogProfile = catalogProfile;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_Defect";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DefectInternalID", getDefectInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DefectInternalID", getDefectInternalID());
        values.put("Defect", getDefect());
        values.put("DefectCategory", getDefectCategory());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("DefectText", getDefectText());
        values.put("DefectCodeCatalog", getDefectCodeCatalog());
        values.put("DefectCodeGroup", getDefectCodeGroup());
        values.put("DefectCode", getDefectCode());
        values.put("DefectCodeVersion", getDefectCodeVersion());
        values.put("DefectObjectCodeCatalog", getDefectObjectCodeCatalog());
        values.put("DefectObjectCodeGroup", getDefectObjectCodeGroup());
        values.put("DefectObjectCode", getDefectObjectCode());
        values.put("DefectiveQuantity", getDefectiveQuantity());
        values.put("DefectiveQuantityUnit", getDefectiveQuantityUnit());
        values.put("ManufacturingOrder", getManufacturingOrder());
        values.put("OrderInternalID", getOrderInternalID());
        values.put("ManufacturingOrderOperation", getManufacturingOrderOperation());
        values.put("ManufacturingOrderSequence", getManufacturingOrderSequence());
        values.put("CreationTime", getCreationTime());
        values.put("LastChangeTime", getLastChangeTime());
        values.put("DefectClass", getDefectClass());
        values.put("NumberOfDefects", getNumberOfDefects());
        values.put("InspPlanOperationInternalID", getInspPlanOperationInternalID());
        values.put("InspectionCharacteristic", getInspectionCharacteristic());
        values.put("InspectionSubsetInternalID", getInspectionSubsetInternalID());
        values.put("MaterialSample", getMaterialSample());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("MainWorkCenterInternalID", getMainWorkCenterInternalID());
        values.put("MainWorkCenterPlant", getMainWorkCenterPlant());
        values.put("MainWorkCenter", getMainWorkCenter());
        values.put("Equipment", getEquipment());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("IsDeleted", getIsDeleted());
        values.put("DefectOrigin", getDefectOrigin());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("InspectionLot", getInspectionLot());
        values.put("CatalogProfile", getCatalogProfile());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DefectInternalID") ) {
                final Object value = values.remove("DefectInternalID");
                if( (value == null) || (!value.equals(getDefectInternalID())) ) {
                    setDefectInternalID(((String) value));
                }
            }
            if( values.containsKey("Defect") ) {
                final Object value = values.remove("Defect");
                if( (value == null) || (!value.equals(getDefect())) ) {
                    setDefect(((String) value));
                }
            }
            if( values.containsKey("DefectCategory") ) {
                final Object value = values.remove("DefectCategory");
                if( (value == null) || (!value.equals(getDefectCategory())) ) {
                    setDefectCategory(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DefectText") ) {
                final Object value = values.remove("DefectText");
                if( (value == null) || (!value.equals(getDefectText())) ) {
                    setDefectText(((String) value));
                }
            }
            if( values.containsKey("DefectCodeCatalog") ) {
                final Object value = values.remove("DefectCodeCatalog");
                if( (value == null) || (!value.equals(getDefectCodeCatalog())) ) {
                    setDefectCodeCatalog(((String) value));
                }
            }
            if( values.containsKey("DefectCodeGroup") ) {
                final Object value = values.remove("DefectCodeGroup");
                if( (value == null) || (!value.equals(getDefectCodeGroup())) ) {
                    setDefectCodeGroup(((String) value));
                }
            }
            if( values.containsKey("DefectCode") ) {
                final Object value = values.remove("DefectCode");
                if( (value == null) || (!value.equals(getDefectCode())) ) {
                    setDefectCode(((String) value));
                }
            }
            if( values.containsKey("DefectCodeVersion") ) {
                final Object value = values.remove("DefectCodeVersion");
                if( (value == null) || (!value.equals(getDefectCodeVersion())) ) {
                    setDefectCodeVersion(((String) value));
                }
            }
            if( values.containsKey("DefectObjectCodeCatalog") ) {
                final Object value = values.remove("DefectObjectCodeCatalog");
                if( (value == null) || (!value.equals(getDefectObjectCodeCatalog())) ) {
                    setDefectObjectCodeCatalog(((String) value));
                }
            }
            if( values.containsKey("DefectObjectCodeGroup") ) {
                final Object value = values.remove("DefectObjectCodeGroup");
                if( (value == null) || (!value.equals(getDefectObjectCodeGroup())) ) {
                    setDefectObjectCodeGroup(((String) value));
                }
            }
            if( values.containsKey("DefectObjectCode") ) {
                final Object value = values.remove("DefectObjectCode");
                if( (value == null) || (!value.equals(getDefectObjectCode())) ) {
                    setDefectObjectCode(((String) value));
                }
            }
            if( values.containsKey("DefectiveQuantity") ) {
                final Object value = values.remove("DefectiveQuantity");
                if( (value == null) || (!value.equals(getDefectiveQuantity())) ) {
                    setDefectiveQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("DefectiveQuantityUnit") ) {
                final Object value = values.remove("DefectiveQuantityUnit");
                if( (value == null) || (!value.equals(getDefectiveQuantityUnit())) ) {
                    setDefectiveQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
            if( values.containsKey("OrderInternalID") ) {
                final Object value = values.remove("OrderInternalID");
                if( (value == null) || (!value.equals(getOrderInternalID())) ) {
                    setOrderInternalID(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderOperation") ) {
                final Object value = values.remove("ManufacturingOrderOperation");
                if( (value == null) || (!value.equals(getManufacturingOrderOperation())) ) {
                    setManufacturingOrderOperation(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderSequence") ) {
                final Object value = values.remove("ManufacturingOrderSequence");
                if( (value == null) || (!value.equals(getManufacturingOrderSequence())) ) {
                    setManufacturingOrderSequence(((String) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangeTime") ) {
                final Object value = values.remove("LastChangeTime");
                if( (value == null) || (!value.equals(getLastChangeTime())) ) {
                    setLastChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("DefectClass") ) {
                final Object value = values.remove("DefectClass");
                if( (value == null) || (!value.equals(getDefectClass())) ) {
                    setDefectClass(((String) value));
                }
            }
            if( values.containsKey("NumberOfDefects") ) {
                final Object value = values.remove("NumberOfDefects");
                if( (value == null) || (!value.equals(getNumberOfDefects())) ) {
                    setNumberOfDefects(((Integer) value));
                }
            }
            if( values.containsKey("InspPlanOperationInternalID") ) {
                final Object value = values.remove("InspPlanOperationInternalID");
                if( (value == null) || (!value.equals(getInspPlanOperationInternalID())) ) {
                    setInspPlanOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("InspectionCharacteristic") ) {
                final Object value = values.remove("InspectionCharacteristic");
                if( (value == null) || (!value.equals(getInspectionCharacteristic())) ) {
                    setInspectionCharacteristic(((String) value));
                }
            }
            if( values.containsKey("InspectionSubsetInternalID") ) {
                final Object value = values.remove("InspectionSubsetInternalID");
                if( (value == null) || (!value.equals(getInspectionSubsetInternalID())) ) {
                    setInspectionSubsetInternalID(((String) value));
                }
            }
            if( values.containsKey("MaterialSample") ) {
                final Object value = values.remove("MaterialSample");
                if( (value == null) || (!value.equals(getMaterialSample())) ) {
                    setMaterialSample(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenterInternalID") ) {
                final Object value = values.remove("MainWorkCenterInternalID");
                if( (value == null) || (!value.equals(getMainWorkCenterInternalID())) ) {
                    setMainWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenterPlant") ) {
                final Object value = values.remove("MainWorkCenterPlant");
                if( (value == null) || (!value.equals(getMainWorkCenterPlant())) ) {
                    setMainWorkCenterPlant(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenter") ) {
                final Object value = values.remove("MainWorkCenter");
                if( (value == null) || (!value.equals(getMainWorkCenter())) ) {
                    setMainWorkCenter(((String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((String) value));
                }
            }
            if( values.containsKey("DefectOrigin") ) {
                final Object value = values.remove("DefectOrigin");
                if( (value == null) || (!value.equals(getDefectOrigin())) ) {
                    setDefectOrigin(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("InspectionLot") ) {
                final Object value = values.remove("InspectionLot");
                if( (value == null) || (!value.equals(getInspectionLot())) ) {
                    setInspectionLot(((String) value));
                }
            }
            if( values.containsKey("CatalogProfile") ) {
                final Object value = values.remove("CatalogProfile");
                if( (value == null) || (!value.equals(getCatalogProfile())) ) {
                    setCatalogProfile(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> DefectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DefectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DefectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DefectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectProcessingService.DEFAULT_SERVICE_PATH);
    }

}
