/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link DefectProcessingServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectProcessingService DefectProcessingService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultDefectProcessingServiceBatch
    extends
    BatchFluentHelperBasic<DefectProcessingServiceBatch, DefectProcessingServiceBatchChangeSet>
    implements
    DefectProcessingServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectProcessingService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultDefectProcessingServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDefectProcessingServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectProcessingService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectProcessingService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultDefectProcessingServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDefectProcessingServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectProcessingService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultDefectProcessingServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public DefectProcessingServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultDefectProcessingServiceBatchChangeSet(this, service);
    }

}
