/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect;

/**
 * Implementation of the {@link DefectProcessingServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectProcessingService DefectProcessingService}.
 *
 */
public class DefaultDefectProcessingServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<DefectProcessingServiceBatch, DefectProcessingServiceBatchChangeSet>
    implements
    DefectProcessingServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectProcessingService service;

    @SuppressWarnings( "deprecation" )
    DefaultDefectProcessingServiceBatchChangeSet(
        @Nonnull final DefaultDefectProcessingServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectProcessingService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultDefectProcessingServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public DefectProcessingServiceBatchChangeSet createDefect( @Nonnull final Defect defect )
    {
        return addRequestCreate(service::createDefect, defect);
    }

    @Nonnull
    @Override
    public DefectProcessingServiceBatchChangeSet updateDefect( @Nonnull final Defect defect )
    {
        return addRequestUpdate(service::updateDefect, defect);
    }

    @Nonnull
    @Override
    public DefectProcessingServiceBatchChangeSet deleteDefect( @Nonnull final Defect defect )
    {
        return addRequestDelete(service::deleteDefect, defect);
    }

}
