/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefectProcessingService DefectProcessingService}.
 *
 */
public interface DefectProcessingServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<DefectProcessingServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<DefectProcessingServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect} entity
     * and save it to the S/4HANA system.
     *
     * @param defect
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect} entity
     *            object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DefectProcessingServiceBatchChangeSet createDefect( @Nonnull final Defect defect );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect}
     * entity and save it to the S/4HANA system.
     *
     * @param defect
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DefectProcessingServiceBatchChangeSet updateDefect( @Nonnull final Defect defect );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect}
     * entity in the S/4HANA system.
     *
     * @param defect
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect} entity
     *            object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DefectProcessingServiceBatchChangeSet deleteDefect( @Nonnull final Defect defect );

}
