/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.field.DefectField DefectField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.link.DefectLink DefectLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECT_INTERNAL_ID
 * DEFECT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECT DEFECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECT_CATEGORY
 * DEFECT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECT_TEXT DEFECT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECT_CODE_CATALOG
 * DEFECT_CODE_CATALOG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECT_CODE_GROUP
 * DEFECT_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECT_CODE DEFECT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECT_CODE_VERSION
 * DEFECT_CODE_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECT_OBJECT_CODE_CATALOG
 * DEFECT_OBJECT_CODE_CATALOG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECT_OBJECT_CODE_GROUP
 * DEFECT_OBJECT_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECT_OBJECT_CODE
 * DEFECT_OBJECT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECTIVE_QUANTITY
 * DEFECTIVE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECTIVE_QUANTITY_UNIT
 * DEFECTIVE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#ORDER_INTERNAL_ID
 * ORDER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#MANUFACTURING_ORDER_OPERATION
 * MANUFACTURING_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#MANUFACTURING_ORDER_SEQUENCE
 * MANUFACTURING_ORDER_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#LAST_CHANGE_TIME
 * LAST_CHANGE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECT_CLASS
 * DEFECT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#NUMBER_OF_DEFECTS
 * NUMBER_OF_DEFECTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#INSP_PLAN_OPERATION_INTERNAL_ID
 * INSP_PLAN_OPERATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#INSPECTION_CHARACTERISTIC
 * INSPECTION_CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#INSPECTION_SUBSET_INTERNAL_ID
 * INSPECTION_SUBSET_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#MATERIAL_SAMPLE
 * MATERIAL_SAMPLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#WORK_CENTER_TYPE_CODE
 * WORK_CENTER_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#MAIN_WORK_CENTER_INTERNAL_ID
 * MAIN_WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#MAIN_WORK_CENTER_PLANT
 * MAIN_WORK_CENTER_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#MAIN_WORK_CENTER
 * MAIN_WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#EQUIPMENT EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#IS_DELETED IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#DEFECT_ORIGIN
 * DEFECT_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#INSPECTION_LOT
 * INSPECTION_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#CATALOG_PROFILE
 * CATALOG_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface DefectSelectable extends EntitySelectable<Defect>
{

}
