/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.field.CreditBlockedDeliveryDocField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.selectable.CreditBlockedDeliveryDocSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Credit Blocked Delivery Document
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CreditBlockedDeliveryDocType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CreditBlockedDeliveryDoc extends VdmEntity<CreditBlockedDeliveryDoc>
{

    /**
     * Selector for all available fields of CreditBlockedDeliveryDoc.
     *
     */
    public final static CreditBlockedDeliveryDocSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @return Delivery
     */
    @Key
    @SerializedName( "DeliveryDocument" )
    @JsonProperty( "DeliveryDocument" )
    @Nullable
    @ODataField( odataName = "DeliveryDocument" )
    private String deliveryDocument;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocument</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> DELIVERY_DOCUMENT =
        new CreditBlockedDeliveryDocField<String>("DeliveryDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentCategory</b>
     * </p>
     *
     * @return SD Document Category
     */
    @SerializedName( "SDDocumentCategory" )
    @JsonProperty( "SDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "SDDocumentCategory" )
    private String sDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentCategory</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> SD_DOCUMENT_CATEGORY =
        new CreditBlockedDeliveryDocField<String>("SDDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> SALES_ORGANIZATION =
        new CreditBlockedDeliveryDocField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> SALES_OFFICE =
        new CreditBlockedDeliveryDocField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @return Shipping Point / Receiving Point
     */
    @SerializedName( "ShippingPoint" )
    @JsonProperty( "ShippingPoint" )
    @Nullable
    @ODataField( odataName = "ShippingPoint" )
    private String shippingPoint;
    /**
     * Use with available fluent helpers to apply the <b>ShippingPoint</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> SHIPPING_POINT =
        new CreditBlockedDeliveryDocField<String>("ShippingPoint");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<LocalDateTime> CREATION_DATE =
        new CreditBlockedDeliveryDocField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> CREATED_BY_USER =
        new CreditBlockedDeliveryDocField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> LAST_CHANGED_BY_USER =
        new CreditBlockedDeliveryDocField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<LocalDateTime> LAST_CHANGE_DATE =
        new CreditBlockedDeliveryDocField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-to Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> SOLD_TO_PARTY =
        new CreditBlockedDeliveryDocField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerCreditAccount</b>
     * </p>
     *
     * @return Customer's account number with credit limit reference
     */
    @SerializedName( "CustomerCreditAccount" )
    @JsonProperty( "CustomerCreditAccount" )
    @Nullable
    @ODataField( odataName = "CustomerCreditAccount" )
    private String customerCreditAccount;
    /**
     * Use with available fluent helpers to apply the <b>CustomerCreditAccount</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> CUSTOMER_CREDIT_ACCOUNT =
        new CreditBlockedDeliveryDocField<String>("CustomerCreditAccount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaCurrency</b>
     * </p>
     *
     * @return Currency key of credit control area
     */
    @SerializedName( "ControllingAreaCurrency" )
    @JsonProperty( "ControllingAreaCurrency" )
    @Nullable
    @ODataField( odataName = "ControllingAreaCurrency" )
    private String controllingAreaCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ControllingAreaCurrency</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> CONTROLLING_AREA_CURRENCY =
        new CreditBlockedDeliveryDocField<String>("ControllingAreaCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReleasedCreditAmount</b>
     * </p>
     *
     * @return Released Credit Value of the Document
     */
    @SerializedName( "ReleasedCreditAmount" )
    @JsonProperty( "ReleasedCreditAmount" )
    @Nullable
    @ODataField( odataName = "ReleasedCreditAmount" )
    private BigDecimal releasedCreditAmount;
    /**
     * Use with available fluent helpers to apply the <b>ReleasedCreditAmount</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<BigDecimal> RELEASED_CREDIT_AMOUNT =
        new CreditBlockedDeliveryDocField<BigDecimal>("ReleasedCreditAmount");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditBlockReleaseDate</b>
     * </p>
     *
     * @return Release date of the document determined by credit management
     */
    @SerializedName( "CreditBlockReleaseDate" )
    @JsonProperty( "CreditBlockReleaseDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreditBlockReleaseDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creditBlockReleaseDate;
    /**
     * Use with available fluent helpers to apply the <b>CreditBlockReleaseDate</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<LocalDateTime> CREDIT_BLOCK_RELEASE_DATE =
        new CreditBlockedDeliveryDocField<LocalDateTime>("CreditBlockReleaseDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NextShippingDate</b>
     * </p>
     *
     * @return Next date
     */
    @SerializedName( "NextShippingDate" )
    @JsonProperty( "NextShippingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "NextShippingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime nextShippingDate;
    /**
     * Use with available fluent helpers to apply the <b>NextShippingDate</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<LocalDateTime> NEXT_SHIPPING_DATE =
        new CreditBlockedDeliveryDocField<LocalDateTime>("NextShippingDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CentralCreditChkTechErrSts</b>
     * </p>
     *
     * @return Status of Technical Error SAP Credit Management
     */
    @SerializedName( "CentralCreditChkTechErrSts" )
    @JsonProperty( "CentralCreditChkTechErrSts" )
    @Nullable
    @ODataField( odataName = "CentralCreditChkTechErrSts" )
    private String centralCreditChkTechErrSts;
    /**
     * Use with available fluent helpers to apply the <b>CentralCreditChkTechErrSts</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> CENTRAL_CREDIT_CHK_TECH_ERR_STS =
        new CreditBlockedDeliveryDocField<String>("CentralCreditChkTechErrSts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Header/All Items)
     */
    @SerializedName( "OverallSDProcessStatus" )
    @JsonProperty( "OverallSDProcessStatus" )
    @Nullable
    @ODataField( odataName = "OverallSDProcessStatus" )
    private String overallSDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallSDProcessStatus</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> OVERALL_SD_PROCESS_STATUS =
        new CreditBlockedDeliveryDocField<String>("OverallSDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallGoodsMovementStatus</b>
     * </p>
     *
     * @return Goods Movement Status (All Items)
     */
    @SerializedName( "OverallGoodsMovementStatus" )
    @JsonProperty( "OverallGoodsMovementStatus" )
    @Nullable
    @ODataField( odataName = "OverallGoodsMovementStatus" )
    private String overallGoodsMovementStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallGoodsMovementStatus</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> OVERALL_GOODS_MOVEMENT_STATUS =
        new CreditBlockedDeliveryDocField<String>("OverallGoodsMovementStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalCreditCheckStatus</b>
     * </p>
     *
     * @return Overall Status of Credit Checks
     */
    @SerializedName( "TotalCreditCheckStatus" )
    @JsonProperty( "TotalCreditCheckStatus" )
    @Nullable
    @ODataField( odataName = "TotalCreditCheckStatus" )
    private String totalCreditCheckStatus;
    /**
     * Use with available fluent helpers to apply the <b>TotalCreditCheckStatus</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> TOTAL_CREDIT_CHECK_STATUS =
        new CreditBlockedDeliveryDocField<String>("TotalCreditCheckStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinDocCreditCheckStatus</b>
     * </p>
     *
     * @return Status of Credit Check Against Financial Document
     */
    @SerializedName( "FinDocCreditCheckStatus" )
    @JsonProperty( "FinDocCreditCheckStatus" )
    @Nullable
    @ODataField( odataName = "FinDocCreditCheckStatus" )
    private String finDocCreditCheckStatus;
    /**
     * Use with available fluent helpers to apply the <b>FinDocCreditCheckStatus</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> FIN_DOC_CREDIT_CHECK_STATUS =
        new CreditBlockedDeliveryDocField<String>("FinDocCreditCheckStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CentralCreditCheckStatus</b>
     * </p>
     *
     * @return Status of Credit Check SAP Credit Management
     */
    @SerializedName( "CentralCreditCheckStatus" )
    @JsonProperty( "CentralCreditCheckStatus" )
    @Nullable
    @ODataField( odataName = "CentralCreditCheckStatus" )
    private String centralCreditCheckStatus;
    /**
     * Use with available fluent helpers to apply the <b>CentralCreditCheckStatus</b> field to query operations.
     *
     */
    public final static CreditBlockedDeliveryDocField<String> CENTRAL_CREDIT_CHECK_STATUS =
        new CreditBlockedDeliveryDocField<String>("CentralCreditCheckStatus");

    @Nonnull
    @Override
    public Class<CreditBlockedDeliveryDoc> getType()
    {
        return CreditBlockedDeliveryDoc.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     */
    public void setDeliveryDocument( @Nullable final String deliveryDocument )
    {
        rememberChangedField("DeliveryDocument", this.deliveryDocument);
        this.deliveryDocument = deliveryDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentCategory</b>
     * </p>
     *
     * @param sDDocumentCategory
     *            SD Document Category
     */
    public void setSDDocumentCategory( @Nullable final String sDDocumentCategory )
    {
        rememberChangedField("SDDocumentCategory", this.sDDocumentCategory);
        this.sDDocumentCategory = sDDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @param shippingPoint
     *            Shipping Point / Receiving Point
     */
    public void setShippingPoint( @Nullable final String shippingPoint )
    {
        rememberChangedField("ShippingPoint", this.shippingPoint);
        this.shippingPoint = shippingPoint;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-to Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerCreditAccount</b>
     * </p>
     *
     * @param customerCreditAccount
     *            Customer's account number with credit limit reference
     */
    public void setCustomerCreditAccount( @Nullable final String customerCreditAccount )
    {
        rememberChangedField("CustomerCreditAccount", this.customerCreditAccount);
        this.customerCreditAccount = customerCreditAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaCurrency</b>
     * </p>
     *
     * @param controllingAreaCurrency
     *            Currency key of credit control area
     */
    public void setControllingAreaCurrency( @Nullable final String controllingAreaCurrency )
    {
        rememberChangedField("ControllingAreaCurrency", this.controllingAreaCurrency);
        this.controllingAreaCurrency = controllingAreaCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReleasedCreditAmount</b>
     * </p>
     *
     * @param releasedCreditAmount
     *            Released Credit Value of the Document
     */
    public void setReleasedCreditAmount( @Nullable final BigDecimal releasedCreditAmount )
    {
        rememberChangedField("ReleasedCreditAmount", this.releasedCreditAmount);
        this.releasedCreditAmount = releasedCreditAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditBlockReleaseDate</b>
     * </p>
     *
     * @param creditBlockReleaseDate
     *            Release date of the document determined by credit management
     */
    public void setCreditBlockReleaseDate( @Nullable final LocalDateTime creditBlockReleaseDate )
    {
        rememberChangedField("CreditBlockReleaseDate", this.creditBlockReleaseDate);
        this.creditBlockReleaseDate = creditBlockReleaseDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NextShippingDate</b>
     * </p>
     *
     * @param nextShippingDate
     *            Next date
     */
    public void setNextShippingDate( @Nullable final LocalDateTime nextShippingDate )
    {
        rememberChangedField("NextShippingDate", this.nextShippingDate);
        this.nextShippingDate = nextShippingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CentralCreditChkTechErrSts</b>
     * </p>
     *
     * @param centralCreditChkTechErrSts
     *            Status of Technical Error SAP Credit Management
     */
    public void setCentralCreditChkTechErrSts( @Nullable final String centralCreditChkTechErrSts )
    {
        rememberChangedField("CentralCreditChkTechErrSts", this.centralCreditChkTechErrSts);
        this.centralCreditChkTechErrSts = centralCreditChkTechErrSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @param overallSDProcessStatus
     *            Overall Processing Status (Header/All Items)
     */
    public void setOverallSDProcessStatus( @Nullable final String overallSDProcessStatus )
    {
        rememberChangedField("OverallSDProcessStatus", this.overallSDProcessStatus);
        this.overallSDProcessStatus = overallSDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallGoodsMovementStatus</b>
     * </p>
     *
     * @param overallGoodsMovementStatus
     *            Goods Movement Status (All Items)
     */
    public void setOverallGoodsMovementStatus( @Nullable final String overallGoodsMovementStatus )
    {
        rememberChangedField("OverallGoodsMovementStatus", this.overallGoodsMovementStatus);
        this.overallGoodsMovementStatus = overallGoodsMovementStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalCreditCheckStatus</b>
     * </p>
     *
     * @param totalCreditCheckStatus
     *            Overall Status of Credit Checks
     */
    public void setTotalCreditCheckStatus( @Nullable final String totalCreditCheckStatus )
    {
        rememberChangedField("TotalCreditCheckStatus", this.totalCreditCheckStatus);
        this.totalCreditCheckStatus = totalCreditCheckStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinDocCreditCheckStatus</b>
     * </p>
     *
     * @param finDocCreditCheckStatus
     *            Status of Credit Check Against Financial Document
     */
    public void setFinDocCreditCheckStatus( @Nullable final String finDocCreditCheckStatus )
    {
        rememberChangedField("FinDocCreditCheckStatus", this.finDocCreditCheckStatus);
        this.finDocCreditCheckStatus = finDocCreditCheckStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CentralCreditCheckStatus</b>
     * </p>
     *
     * @param centralCreditCheckStatus
     *            Status of Credit Check SAP Credit Management
     */
    public void setCentralCreditCheckStatus( @Nullable final String centralCreditCheckStatus )
    {
        rememberChangedField("CentralCreditCheckStatus", this.centralCreditCheckStatus);
        this.centralCreditCheckStatus = centralCreditCheckStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CreditBlockedDeliveryDoc";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DeliveryDocument", getDeliveryDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DeliveryDocument", getDeliveryDocument());
        values.put("SDDocumentCategory", getSDDocumentCategory());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("SalesOffice", getSalesOffice());
        values.put("ShippingPoint", getShippingPoint());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("SoldToParty", getSoldToParty());
        values.put("CustomerCreditAccount", getCustomerCreditAccount());
        values.put("ControllingAreaCurrency", getControllingAreaCurrency());
        values.put("ReleasedCreditAmount", getReleasedCreditAmount());
        values.put("CreditBlockReleaseDate", getCreditBlockReleaseDate());
        values.put("NextShippingDate", getNextShippingDate());
        values.put("CentralCreditChkTechErrSts", getCentralCreditChkTechErrSts());
        values.put("OverallSDProcessStatus", getOverallSDProcessStatus());
        values.put("OverallGoodsMovementStatus", getOverallGoodsMovementStatus());
        values.put("TotalCreditCheckStatus", getTotalCreditCheckStatus());
        values.put("FinDocCreditCheckStatus", getFinDocCreditCheckStatus());
        values.put("CentralCreditCheckStatus", getCentralCreditCheckStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DeliveryDocument") ) {
                final Object value = values.remove("DeliveryDocument");
                if( (value == null) || (!value.equals(getDeliveryDocument())) ) {
                    setDeliveryDocument(((String) value));
                }
            }
            if( values.containsKey("SDDocumentCategory") ) {
                final Object value = values.remove("SDDocumentCategory");
                if( (value == null) || (!value.equals(getSDDocumentCategory())) ) {
                    setSDDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("ShippingPoint") ) {
                final Object value = values.remove("ShippingPoint");
                if( (value == null) || (!value.equals(getShippingPoint())) ) {
                    setShippingPoint(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("CustomerCreditAccount") ) {
                final Object value = values.remove("CustomerCreditAccount");
                if( (value == null) || (!value.equals(getCustomerCreditAccount())) ) {
                    setCustomerCreditAccount(((String) value));
                }
            }
            if( values.containsKey("ControllingAreaCurrency") ) {
                final Object value = values.remove("ControllingAreaCurrency");
                if( (value == null) || (!value.equals(getControllingAreaCurrency())) ) {
                    setControllingAreaCurrency(((String) value));
                }
            }
            if( values.containsKey("ReleasedCreditAmount") ) {
                final Object value = values.remove("ReleasedCreditAmount");
                if( (value == null) || (!value.equals(getReleasedCreditAmount())) ) {
                    setReleasedCreditAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditBlockReleaseDate") ) {
                final Object value = values.remove("CreditBlockReleaseDate");
                if( (value == null) || (!value.equals(getCreditBlockReleaseDate())) ) {
                    setCreditBlockReleaseDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("NextShippingDate") ) {
                final Object value = values.remove("NextShippingDate");
                if( (value == null) || (!value.equals(getNextShippingDate())) ) {
                    setNextShippingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CentralCreditChkTechErrSts") ) {
                final Object value = values.remove("CentralCreditChkTechErrSts");
                if( (value == null) || (!value.equals(getCentralCreditChkTechErrSts())) ) {
                    setCentralCreditChkTechErrSts(((String) value));
                }
            }
            if( values.containsKey("OverallSDProcessStatus") ) {
                final Object value = values.remove("OverallSDProcessStatus");
                if( (value == null) || (!value.equals(getOverallSDProcessStatus())) ) {
                    setOverallSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("OverallGoodsMovementStatus") ) {
                final Object value = values.remove("OverallGoodsMovementStatus");
                if( (value == null) || (!value.equals(getOverallGoodsMovementStatus())) ) {
                    setOverallGoodsMovementStatus(((String) value));
                }
            }
            if( values.containsKey("TotalCreditCheckStatus") ) {
                final Object value = values.remove("TotalCreditCheckStatus");
                if( (value == null) || (!value.equals(getTotalCreditCheckStatus())) ) {
                    setTotalCreditCheckStatus(((String) value));
                }
            }
            if( values.containsKey("FinDocCreditCheckStatus") ) {
                final Object value = values.remove("FinDocCreditCheckStatus");
                if( (value == null) || (!value.equals(getFinDocCreditCheckStatus())) ) {
                    setFinDocCreditCheckStatus(((String) value));
                }
            }
            if( values.containsKey("CentralCreditCheckStatus") ) {
                final Object value = values.remove("CentralCreditCheckStatus");
                if( (value == null) || (!value.equals(getCentralCreditCheckStatus())) ) {
                    setCentralCreditCheckStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CreditBlockedDeliveryDocField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CreditBlockedDeliveryDocField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CreditBlockedDeliveryDocField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CreditBlockedDeliveryDocField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DeliveryDocumentWithCreditBlocksService.DEFAULT_SERVICE_PATH);
    }

}
