/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>ReturnMessage</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ReturnMessage extends VdmComplex<ReturnMessage>
{

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>MessageType</b>
     * </p>
     *
     * @param messageType
     *
     * @return Message Type
     */
    @SerializedName( "MessageType" )
    @JsonProperty( "MessageType" )
    @Nullable
    @ODataField( odataName = "MessageType" )
    private String messageType;
    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>Message</b>
     * </p>
     *
     * @param message
     *
     * @return Message
     */
    @SerializedName( "Message" )
    @JsonProperty( "Message" )
    @Nullable
    @ODataField( odataName = "Message" )
    private String message;

    @Nonnull
    @Override
    public Class<ReturnMessage> getType()
    {
        return ReturnMessage.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MessageType", getMessageType());
        values.put("Message", getMessage());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MessageType") ) {
                final Object value = values.remove("MessageType");
                if( (value == null) || (!value.equals(getMessageType())) ) {
                    setMessageType(((String) value));
                }
            }
            if( values.containsKey("Message") ) {
                final Object value = values.remove("Message");
                if( (value == null) || (!value.equals(getMessage())) ) {
                    setMessage(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>MessageType</b>
     * </p>
     *
     * @param messageType
     *            Message Type
     */
    public void setMessageType( @Nullable final String messageType )
    {
        rememberChangedField("MessageType", this.messageType);
        this.messageType = messageType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>Message</b>
     * </p>
     *
     * @param message
     *            Message
     */
    public void setMessage( @Nullable final String message )
    {
        rememberChangedField("Message", this.message);
        this.message = message;
    }

}
