/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.field.SalesDocumentRjcnReasonField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.selectable.SalesDocumentRjcnReasonSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Rejection Reason
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesDocumentRjcnReasonType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesDocumentRjcnReason extends VdmEntity<SalesDocumentRjcnReason>
{

    /**
     * Selector for all available fields of SalesDocumentRjcnReason.
     *
     */
    public final static SalesDocumentRjcnReasonSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @return Reason for Rejection of Sales Documents
     */
    @Key
    @SerializedName( "SalesDocumentRjcnReason" )
    @JsonProperty( "SalesDocumentRjcnReason" )
    @Nullable
    @ODataField( odataName = "SalesDocumentRjcnReason" )
    private String salesDocumentRjcnReason;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentRjcnReason</b> field to query operations.
     *
     */
    public final static SalesDocumentRjcnReasonField<String> SALES_DOCUMENT_RJCN_REASON =
        new SalesDocumentRjcnReasonField<String>("SalesDocumentRjcnReason");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason_Text</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "SalesDocumentRjcnReason_Text" )
    @JsonProperty( "SalesDocumentRjcnReason_Text" )
    @Nullable
    @ODataField( odataName = "SalesDocumentRjcnReason_Text" )
    private String salesDocumentRjcnReason_Text;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentRjcnReason_Text</b> field to query operations.
     *
     */
    public final static SalesDocumentRjcnReasonField<String> SALES_DOCUMENT_RJCN_REASON_TEXT =
        new SalesDocumentRjcnReasonField<String>("SalesDocumentRjcnReason_Text");

    @Nonnull
    @Override
    public Class<SalesDocumentRjcnReason> getType()
    {
        return SalesDocumentRjcnReason.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @param salesDocumentRjcnReason
     *            Reason for Rejection of Sales Documents
     */
    public void setSalesDocumentRjcnReason( @Nullable final String salesDocumentRjcnReason )
    {
        rememberChangedField("SalesDocumentRjcnReason", this.salesDocumentRjcnReason);
        this.salesDocumentRjcnReason = salesDocumentRjcnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason_Text</b>
     * </p>
     *
     * @param salesDocumentRjcnReason_Text
     *            Description
     */
    public void setSalesDocumentRjcnReason_Text( @Nullable final String salesDocumentRjcnReason_Text )
    {
        rememberChangedField("SalesDocumentRjcnReason_Text", this.salesDocumentRjcnReason_Text);
        this.salesDocumentRjcnReason_Text = salesDocumentRjcnReason_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesDocumentRjcnReason";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesDocumentRjcnReason", getSalesDocumentRjcnReason());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesDocumentRjcnReason", getSalesDocumentRjcnReason());
        values.put("SalesDocumentRjcnReason_Text", getSalesDocumentRjcnReason_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesDocumentRjcnReason") ) {
                final Object value = values.remove("SalesDocumentRjcnReason");
                if( (value == null) || (!value.equals(getSalesDocumentRjcnReason())) ) {
                    setSalesDocumentRjcnReason(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentRjcnReason_Text") ) {
                final Object value = values.remove("SalesDocumentRjcnReason_Text");
                if( (value == null) || (!value.equals(getSalesDocumentRjcnReason_Text())) ) {
                    setSalesDocumentRjcnReason_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesDocumentRjcnReasonField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesDocumentRjcnReasonField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesDocumentRjcnReasonField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesDocumentRjcnReasonField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DeliveryDocumentWithCreditBlocksService.DEFAULT_SERVICE_PATH);
    }

}
