/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link DeliveryDocumentWithCreditBlocksServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DeliveryDocumentWithCreditBlocksService
 * DeliveryDocumentWithCreditBlocksService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultDeliveryDocumentWithCreditBlocksServiceBatch
    extends
    BatchFluentHelperBasic<DeliveryDocumentWithCreditBlocksServiceBatch, DeliveryDocumentWithCreditBlocksServiceBatchChangeSet>
    implements
    DeliveryDocumentWithCreditBlocksServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DeliveryDocumentWithCreditBlocksService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultDeliveryDocumentWithCreditBlocksServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDeliveryDocumentWithCreditBlocksServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DeliveryDocumentWithCreditBlocksService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.DeliveryDocumentWithCreditBlocksService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultDeliveryDocumentWithCreditBlocksServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDeliveryDocumentWithCreditBlocksServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DeliveryDocumentWithCreditBlocksService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultDeliveryDocumentWithCreditBlocksServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public DeliveryDocumentWithCreditBlocksServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultDeliveryDocumentWithCreditBlocksServiceBatchChangeSet(this, service);
    }

}
