/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link DeliveryDocumentWithCreditBlocksServiceBatchChangeSet} interface, enabling you to
 * combine multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DeliveryDocumentWithCreditBlocksService
 * DeliveryDocumentWithCreditBlocksService}.
 *
 */
public class DefaultDeliveryDocumentWithCreditBlocksServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<DeliveryDocumentWithCreditBlocksServiceBatch, DeliveryDocumentWithCreditBlocksServiceBatchChangeSet>
    implements
    DeliveryDocumentWithCreditBlocksServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DeliveryDocumentWithCreditBlocksService service;

    @SuppressWarnings( "deprecation" )
    DefaultDeliveryDocumentWithCreditBlocksServiceBatchChangeSet(
        @Nonnull final DefaultDeliveryDocumentWithCreditBlocksServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DeliveryDocumentWithCreditBlocksService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultDeliveryDocumentWithCreditBlocksServiceBatchChangeSet getThis()
    {
        return this;
    }

}
