/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc
 * CreditBlockedDeliveryDoc}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.field.CreditBlockedDeliveryDocField
 * CreditBlockedDeliveryDocField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.link.CreditBlockedDeliveryDocLink
 * CreditBlockedDeliveryDocLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#DELIVERY_DOCUMENT
 * DELIVERY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#SD_DOCUMENT_CATEGORY
 * SD_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#SALES_OFFICE
 * SALES_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#SHIPPING_POINT
 * SHIPPING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#CUSTOMER_CREDIT_ACCOUNT
 * CUSTOMER_CREDIT_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#CONTROLLING_AREA_CURRENCY
 * CONTROLLING_AREA_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#RELEASED_CREDIT_AMOUNT
 * RELEASED_CREDIT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#CREDIT_BLOCK_RELEASE_DATE
 * CREDIT_BLOCK_RELEASE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#NEXT_SHIPPING_DATE
 * NEXT_SHIPPING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#CENTRAL_CREDIT_CHK_TECH_ERR_STS
 * CENTRAL_CREDIT_CHK_TECH_ERR_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#OVERALL_SD_PROCESS_STATUS
 * OVERALL_SD_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#OVERALL_GOODS_MOVEMENT_STATUS
 * OVERALL_GOODS_MOVEMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#TOTAL_CREDIT_CHECK_STATUS
 * TOTAL_CREDIT_CHECK_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#FIN_DOC_CREDIT_CHECK_STATUS
 * FIN_DOC_CREDIT_CHECK_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDoc#CENTRAL_CREDIT_CHECK_STATUS
 * CENTRAL_CREDIT_CHECK_STATUS}</li>
 * </ul>
 *
 */
public interface CreditBlockedDeliveryDocSelectable extends EntitySelectable<CreditBlockedDeliveryDoc>
{

}
