/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.SalesDocumentRjcnReason;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.SalesDocumentRjcnReason
 * SalesDocumentRjcnReason}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.field.SalesDocumentRjcnReasonField
 * SalesDocumentRjcnReasonField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.link.SalesDocumentRjcnReasonLink
 * SalesDocumentRjcnReasonLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.SalesDocumentRjcnReason#SALES_DOCUMENT_RJCN_REASON
 * SALES_DOCUMENT_RJCN_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.SalesDocumentRjcnReason#SALES_DOCUMENT_RJCN_REASON_TEXT
 * SALES_DOCUMENT_RJCN_REASON_TEXT}</li>
 * </ul>
 *
 */
public interface SalesDocumentRjcnReasonSelectable extends EntitySelectable<SalesDocumentRjcnReason>
{

}
