/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link DistributionChannelServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DistributionChannelService DistributionChannelService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultDistributionChannelServiceBatch
    extends
    BatchFluentHelperBasic<DistributionChannelServiceBatch, DistributionChannelServiceBatchChangeSet>
    implements
    DistributionChannelServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DistributionChannelService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultDistributionChannelServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDistributionChannelServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DistributionChannelService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.DistributionChannelService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultDistributionChannelServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDistributionChannelServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DistributionChannelService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultDistributionChannelServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public DistributionChannelServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultDistributionChannelServiceBatchChangeSet(this, service);
    }

}
