/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link DistributionChannelServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DistributionChannelService DistributionChannelService}.
 *
 */
public class DefaultDistributionChannelServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<DistributionChannelServiceBatch, DistributionChannelServiceBatchChangeSet>
    implements
    DistributionChannelServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DistributionChannelService service;

    @SuppressWarnings( "deprecation" )
    DefaultDistributionChannelServiceBatchChangeSet(
        @Nonnull final DefaultDistributionChannelServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DistributionChannelService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultDistributionChannelServiceBatchChangeSet getThis()
    {
        return this;
    }

}
